var origCameraSetting = {};
var cameraSettings = {};
var text = {};
var NDI_Model = 0;
var NDI_Enable = 0;
var addTime = 0;
var urlToSend = "";
var lastPowerStatus = "on";
var okLang = "OK";
var yesLang = "Yes";
var noLang = "No";
var warningMessage = "";
var fwUpdateRunning = 0;
var currObjId = "";
var isProcessingMaxSoundQty = false;
var isStandByStatus = false;
var gIsGetStandByStatus = false;
let gCheckFiveTimeToDebugMode = 0;
let gLastClickTime = 0;
var isDebugModeDisplay = false;
var isFunctionDisplay = false;
var gWebSocketErrorBlockUIPage = false;
var gIsCheckDanteActiveIsExport = false;
var gIsControlByGui = false;
var nonceCount = 0;
let langText = ["English", "繁體中文", "简体中文"];
var gHadLogin = false;
var messageQueue = [];
var nonceCount = 0;
var reconnectAttempts = 0;
var messageCount = { sent: 0, received: 0 };
let sessionToken = null;
let currentUser = null;
let authChallenge = null;
var isViewerLogin = false;
var isAuthenticated = false;
var gSetPasswordSuccess = false;
const LOGIN_STATUS_KEY = 'gHadLogin';
let gConnectionStartTime = 0;
let gServerTimeBase = 0;
let gClientId = "";
var PUBLIC_KEY = null;
var gIsAlertVisible = false;
var gRemainingTime = 0;
var lastSyncTime = {};
var TEMP_KEY = sessionStorage.getItem('tempKey') || null;
var WEB_TEMP_KEYPAIR = null;
let JWT_VERIFY_KEY = null;
let TIME_OFFSET = 0;
let TIME_BASE_ESTABLISHED = false;
let RSA_KEY_READY = false;
let PENDING_REQUESTS = [];

var gIsOtaUpdate = false;
var gVersion = "";
var gUseNewRender = false;

function initializeTimeBase() {
    const savedOffset = sessionStorage.getItem('timeOffset');
    const savedBaseFlag = sessionStorage.getItem('timeBaseEstablished');
    
    if (savedOffset && savedBaseFlag === 'true') {
        TIME_OFFSET = parseInt(savedOffset);
        TIME_BASE_ESTABLISHED = true;
    }
}


//--------------
function initTimeBase() 
{
    gConnectionStartTime = Date.now();
    gClientId = generateClientId();
}

function generateClientId() 
{
    const id = 'web_' + Date.now() + '_' + Math.floor(Math.random() * 1000);
    return id;
}

function getRelativeTimestamp() 
{
    const timestamp = Date.now() - gConnectionStartTime;
    return timestamp.toString();
}

const OnOff2BoolMap = new Map([
    ["on", true],
    ["off", false]
]);

function loadLoginStatus() {
    const savedStatus = sessionStorage.getItem(LOGIN_STATUS_KEY);     
    if (savedStatus !== null) {
        gHadLogin = JSON.parse(savedStatus);
    }
}

function saveLoginStatus(status) {
    try {
        gHadLogin = Boolean(status);
        sessionStorage.setItem(LOGIN_STATUS_KEY, JSON.stringify(gHadLogin));
    } catch (error) {
    }
}

function clearLoginStatus() {
    gHadLogin = false;
    sessionStorage.removeItem(LOGIN_STATUS_KEY);
}

function setLoginStatus(status) {
    const newStatus = Boolean(status);
    saveLoginStatus(newStatus);
}

function getLoginStatus() {
    return gHadLogin;
}

//--------------

function OnOff2Bool(OnOff) {
    if (OnOff == "on") {
        return true;
    } else {
        return false;
    }
}

function AddParameter(parameter, value) {
    if (addTime++ == 0) {
        urlToSend = urlToSend + parameter + '\=' + value;
    } else {
        urlToSend = urlToSend + '\&' + parameter + '\=' + value;
    }
}

function updatePowerStatus() {
    var param = {};

    $.ajax({
        url: "/powerModeInq",
        type: "POST",
        dataType: "json",
        contentType: "application/json",
        data: JSON.stringify(param),
        scriptCharset: "utf-8",
        timeout: 20 * 1000, // milliseconds
        error: function (xhr) {
            ;
        },
        success: function (response) {
            if (isJSON(response) == true) {
                if (response.STATUS == "NG") {
                    ;
                } else {

                    if (lastPowerStatus != response.POWERMODE.toLowerCase()) {
                        UnblockUIforPage();
                        if (response.POWERMODE == "ON") {
                            document.getElementById("powerBtn").className = "PowerOff_Btn";
                            $('.LeftMenuDiv').removeClass("disabled").prop("disabled", false);
                            $('#DivMainPage *').prop("disabled", false);
                            if (lastPowerStatus == "off") {
                                showLeftMenu();
                            }
                            $('#Div_LeftStream').trigger('click');
                        } else {
                            changeMainPage(null);
                            document.getElementById("powerBtn").className = "PowerStandby_Btn";
                            $(".LeftMenuDiv").addClass("disabled").prop("disabled", true).off('click');
                            $("#DivMainPage *").prop("disabled", true);
                            openPowerOff();
                        }
                    }
                    lastPowerStatus = response.POWERMODE.toLowerCase();
                }
            } else {
                ;
            }
        }
    });
}

function sendPowerCommand() {
    if (websocket.readyState == 3) {
        initWebSocketIndex();
    }
    if (lastPowerStatus == "on") {
        sendMessageIndex("StandBy");
    }
    else {
        sendMessageIndex("WakeUp");
    }
    sendMessageIndex("GetStandByStatus");
/*
    var cgiParam = {};
    addTime = 0;
    urlToSend = "/cgi/main.cgi?";

    if (lastPowerStatus == "on") {
        AddParameter("System", "standby");
    } else {
        AddParameter("System", "on");
    }

    blockUIforPage();
    $.ajax({
        url: urlToSend,
        type: "POST",
        error: function (xhr) {
            UnblockUIforPage();
            console.log("Send Power Command Error");
            alert("Fail to set, please try again");
        },
        success: function (response) {
            console.log("Power command send to " + cameraSettings.CameraName);
        }
    });
*/
}

function selectProfileOnChange() {
    var jsonmsg = {};
    var idString = document.getElementById("Select_Profile").value;
    console.log( "idString :", idString);
    gUpdateXMLProfile = false;

    jsonmsg.Command = "LoadProfile";
    jsonmsg.ID = parseInt(idString, 10);
    sendMessageIndex("LoadProfile", jsonmsg);
    sendMessageIndex("GetCurrentProfileID");
    blockUIforPage();
}

function checkSelectProfile(){
    var selectElement = document.getElementById("Select_Profile");
    var selectedValue = selectElement.value;
    if (selectedValue === "") 
    {
        sendMessageIndex("GetAllProfile");
        sendMessageIndex("GetCurrentProfileID");
    }
}

$(document).ready(function () {
    $("#DivRightUpMenuPage").load("./page/rightupmenu.html", function () {
        $("#DivLeftmenuPage").load("./page/leftmenu.html", function () {
            loadLoginStatus();
            initWebSocketIndex();
            //openLeftMenu();
        });
    });
});

function updateModelNameLabel() {
    switch (cameraSettings.ModelName) {
        case "CV730-HN":
            $("#modelNameLabel").text("CV730-BHN/WHN");
            break;
        default:
            $("#modelNameLabel").text(cameraSettings.ModelName);
    }
}

var wsUri = "ws://"+location.hostname+":9015";
var wssUri = "wss://"+location.hostname+":9055";
var websocket = null;
var gProtocolStr = document.location.protocol;


function sendMessageIndex(cmd,data) {

    var msg = cmd;
    var jsonmsg = {};

    if ( websocket != null )
    {
        jsonmsg.Command = msg;
        if (msg == "LoadProfile") {
            jsonmsg = data;
        }
        else if (msg == "SetDanteActiveDataHint") {
            jsonmsg = data;
        }
        else if (msg == "SetSystemSetting") {
            jsonmsg = data;
        }

        if (websocket.readyState == 1) {
        websocket.send( JSON.stringify(jsonmsg) );
        //console.log( "string sent :", JSON.stringify(jsonmsg) );
        }
        else {
            //do something
            // console.log( "websocket.readyState :", websocket.readyState );
            if(websocket.readyState == 3)
            {
                gWebSocketErrorBlockUIPage = true;
                blockUIforPage();
                setLoginStatus(false);
                gHadLogin = false;
                clearLoginStatus();
            }
        }
    }
}

function initWebSocketIndex() {

    if (websocket && websocket.readyState == 1) {
        console.log('Already connection');
        gWebSocketErrorBlockUIPage = false;
        UnblockUIforPage();
        sendMessageIndex("GetCurrentLanguage");
        sendMessageIndex("GetCurrentProfileID");
        sendMessageIndex("GetSoundMaxQtyProcessStatus");
        sendMessageIndex("GetStandByStatus");        
        sendMessageIndex("GetAllProfile");
        sendMessageIndex("GetCurrentProfileID");
        sendMessageIndex("GetCurrentVersion");
        openLeftMenu();
    }
    else
    {
        initTimeBase();
        initializeTimeBase();

        if(gProtocolStr == "http:")
            websocket = new WebSocket( wsUri );
        else
            websocket = new WebSocket( wssUri );
    }

    websocket.addEventListener('open', function() {
        console.log('open connection');
        gWebSocketErrorBlockUIPage = false;
        UnblockUIforPage();
        sendMessageIndex("GetCurrentProfileID");
        sendMessageIndex("GetSoundMaxQtyProcessStatus");
        sendMessageIndex("GetStandByStatus");        
        sendMessageIndex("GetAllProfile");
        sendMessageIndex("GetCurrentProfileID");
        sendMessageIndex("GetCurrentVersion");
        openLeftMenu();
        if(!gHadLogin)
        {
            createLoginPanel();
        }
        else
        {
            hideLoginPanel(); 
            isViewerLogin = false;
            isAuthenticated = true;
        }

        //hideLoginPanel(); //hideLogin
        protectIsAuthenticated();
        sendMessageIndex("GetCurrentLanguage");

    });

    websocket.addEventListener('error',function(evt) {
        gWebSocketErrorBlockUIPage = true;
        setLoginStatus(false);
        gHadLogin = false;
        clearLoginStatus();
        setTimeout(showWebSocketLost,1000);//setTimeout(showWebSocketLost,1000);//blockUIforPage();
    });

    websocket.addEventListener('message',function(evt){
        //console.log('Message received');
        if (evt.data instanceof Blob) {
        
        }
        else
        {
            receivedDataIndex(evt.data);
        }
    });

    websocket.onclose = function(evt) 
    {
         console.log('index websocket.onclose');
        gWebSocketErrorBlockUIPage = true;
        setLoginStatus(false);
        gHadLogin = false;
        clearLoginStatus();
        setTimeout(showWebSocketLost,1000);//setTimeout(showWebSocketLost,1000);//blockUIforPage();
    };


}

function receivedDataIndex(data) {
    //console.log(' data : ',  data); 
    var tempData;

    if (typeof data === 'string') 
    {
        tempData = data;
    }
    else if (data instanceof ArrayBuffer) 
    {
        return;
    }
    
    var obj = JSON.parse(tempData);
    //console.log('obj.Reply:',obj.Reply);
    switch (obj.Reply){
        case "GetAllProfile":
            updatedProfileFilesList(obj);
            break;

        case "GetCurrentProfileID":
            updatedProfileIndex(obj);
            break;

        case "LoadProfile":
            if("Status" in obj)
            {
                if(obj.Status.includes("Finished"))
                {
                    gUpdateXMLProfile = false;

                    sendMessageIndex("GetCurrentProfileID");
                    UnblockUIforPage();

                    if(gPageIsInAIDirector)
                    {
                        gPageIsInAIDirector = false;
                        let Profile = document.getElementById('Select_Profile');
                        setTimeout(function() {
                            AiDirector_sendMessage("GetAIDirectorProfileDataForDirector", {
                                Command: "GetAIDirectorProfileDataForDirector",
                                ProfileIndex: parseInt(Profile.value,10),
                                ConfigFileIndex: 0,
                            });
                        }, 100);

                        gGetProfileTempData = true;
                        getAIDirectorBlockUIPage = true;
                        gNowGetProfileResponseCount = 0;
                        gProfileResponseCountEnd = btnTexts.length;

                        blockUIforPage();
                    }
                }
            }
            break;

        case "GetStandByStatus":
            updatedGetStandByStatus(obj);
            break;
        case "GetSoundMaxQtyProcessStatus":
            updatedGetSoundMaxQtyProcessStatus(obj);
            break;
        case "GetCurrentVersion":
            updatedGetCurrentVersionString(obj);
            break;
        case "CheckDanteActiveDataIsExport":
            updatedCheckDanteActiveDataIsExport(obj);
            break;

        case "GetCurrentLanguage":
            if( "Language" in obj)
            {
                document.getElementById("GobalSelectLanguage").value = obj.Language;
                if (window.LanguageManager && typeof window.LanguageManager.changeLanguage === "function") 
                {
                  window.LanguageManager.changeLanguage(obj.Language);
                }

                updateLoginDisplay();
            }
            break;
        case "SendGuiControlStatus":
            if( "ControlByGui" in obj)
            {
                if(obj.ControlByGui)
                {
                    gIsControlByGui = true;
                    setTimeout(showControlByGUI,1000);
                }
            }
            break;
        case "GetSystemSetting":
            handleSystemSettingResponse(obj);
            break;

        case "KeepAlive":
            handleKeepAlive(obj);
            break;

        case "CheckDirectorRun":
            handleCheckDirectorRun(obj)
            break;
            
    }
}

var gCheckLive = false;
var gCheckTimer = null;

var gCheckDirectorRun = false;
var gCheckDirectorRunTimer = null;
var gDirectorRunEndStatus = true;
var gDirectorCheckInterval = null;


function startGlobalCheck() 
{
    if(gDirectorCheckInterval == null)
    {
        gDirectorCheckInterval = setInterval(() => {
            sendCheckDirectorRunCommand();
        }, 200);
    }

    setInterval(() => {
        sendKeepAliveCommand();
    }, 1000);
    
    setInterval(() => {
        if (gCheckTimer) return;
        
        gCheckTimer = setTimeout(() => {
            if (!gCheckLive) 
            {
                gHadLogin = false;
                clearLoginStatus();
            } 
            gCheckLive = false;
            gCheckTimer = null;
        }, 5000);
    }, 5000);

    setInterval(() => {
        if (gCheckDirectorRunTimer) return;
        
        gCheckDirectorRunTimer = setTimeout(() => {
            if(gCheckDirectorRun)
            {
                if ($(".Director_Btn").hasClass('inactive')) 
                {
                    $(".Director_Btn").removeClass('inactive').addClass('active');
                    sendCheckDirectorRunCommand();
                }
            }
            else
            {
                if ($(".Director_Btn").hasClass('active')) 
                {
                    $(".Director_Btn").removeClass('active').addClass('inactive');
                }
            }
            gCheckDirectorRunTimer = null;

        }, 350);
    }, 300);
}

function handleKeepAlive(obj) {
    gCheckLive = true;
}

function sendKeepAliveCommand() {
    sendMessageIndex("KeepAlive");
}

function handleCheckDirectorRun(obj) 
{
    if(obj.DirectorRunStatus !== undefined)
    {
        gCheckDirectorRun = obj.DirectorRunStatus;

        if(gCheckDirectorRun)
        {
            if ($(".Director_Btn").hasClass('inactive')) 
            {
                $(".Director_Btn").removeClass('inactive').addClass('active');
                sendCheckDirectorRunCommand();
            }
        }
        else
        {
            clearInterval(gDirectorCheckInterval);

            if ($(".Director_Btn").hasClass('active')) 
            {
                $(".Director_Btn").removeClass('active').addClass('inactive');
            }
        }
    }
}

function sendCheckDirectorRunCommand()
{
    sendMessageIndex("CheckDirectorRun");
}

function handleSystemSettingResponse(obj) 
{
    if (obj.System && obj.System.Authentication) {
        var authResponse = obj.System.Authentication;
        switch (authResponse.Action) 
        {
            case "ChangePassword":
                if (authResponse.Status === "Success") {
                    const passwordInputs = ['password_1', 'password_2', 'password_3'];
                    passwordInputs.forEach(id => {
                        const input = document.getElementById(id);
                        if (input) {
                            input.type = 'password';
                            // if(id == 'password_1')
                            // {
                            //     makePasswordFieldReadonly(id);
                            // }
                        }
                    });
                    const concealButtons = ['conceal_1', 'conceal_2', 'conceal_3'];
                    concealButtons.forEach(id => {
                        const button = document.getElementById(id);
                        if (button) {
                            button.classList.remove('shown');
                        }
                    });
                    const randomPassword = generateRandomPassword();
                    // const password1Input = document.getElementById('password_1');
                    // if (password1Input) {
                    //     password1Input.value = randomPassword;
                    //     makePasswordFieldReadonly('password_1');
                    // }
                    const otherInputs = ['password_1','password_2', 'password_3'];
                    otherInputs.forEach(id => {
                        const input = document.getElementById(id);
                        if (input) {
                            input.value = '';
                            passwordStore[id] = '';
                        }
                    });
                    gSetPasswordSuccess = true;
                    showLoginError('password change success');

                    let changeApply = document.getElementById('applyWebUserButton');
                    let changeCancel = document.getElementById('cancelWebUserButton');
                    if(changeApply)
                        changeApply.style.disabled = true;
                    if(changeCancel)
                        changeCancel.style.disabled = true;

                    if(gUsername)
                    {
                        firstGetInitPassword = true;
                        fetchCurrentPassword(gUsername);
                    }

                }
                break;
            case "RequestTempKey":
                if (authResponse.Status === "Success" && authResponse.TempKey) 
                {
                    TEMP_KEY = authResponse.TempKey;
                    PUBLIC_KEY = authResponse.TempKey;
                    sessionStorage.setItem('tempKey', TEMP_KEY);

                    if (authResponse.JwtKey) {
                        JWT_VERIFY_KEY = authResponse.JwtKey;
                        sessionStorage.setItem('jwtKey', JWT_VERIFY_KEY);
                    }

                    if (authResponse.ServerTimeBase) 
                    {
                        const webRequestTime = Date.now();
                        const apResponseTime = new Date(authResponse.ServerTimeBase).getTime();
                        
                        TIME_OFFSET = apResponseTime - webRequestTime;
                        TIME_BASE_ESTABLISHED = true;
                        
                        sessionStorage.setItem('timeOffset', TIME_OFFSET.toString());
                        sessionStorage.setItem('timeBaseEstablished', 'true');
                        
                        gServerTimeBase = apResponseTime;
                    }
                    
                    setTimeout(() => {
                        sendGetAllLockStatus();
                    }, 150);

                    if (currentUser && getCurrentPassword()) 
                    {
                        const lockStatus = LoginAttemptTracker.checkLockStatus(currentUser);
                        if (lockStatus.isLocked) 
                        {
                            showLoginError(lockStatus.message);
                            clearCurrentPassword();
                            const loginButton = document.getElementById('btnLogin');
                            if (loginButton) loginButton.disabled = false;
                            return;
                        }

                        setTimeout(() => {
                            BtnLoginClicked();  
                        }, 150);
                    }
                }
                break;
            case "Success":
                if (!authResponse.AuthToken || !JWT_VERIFY_KEY) {
                    showLoginError("Authentication verification failed");
                    clearCurrentPassword();
                    const loginButton = document.getElementById('btnLogin');
                    if (loginButton) loginButton.disabled = false;
                    return;
                }

                const jwtVerifier = getJWTVerifier();
                jwtVerifier.verifyJWT(authResponse.AuthToken, JWT_VERIFY_KEY)
                    .then(isValid => {
                        if (!isValid) {
                            showLoginError("Authentication verification failed");
                            clearCurrentPassword();
                            const loginButton = document.getElementById('btnLogin');
                            if (loginButton) loginButton.disabled = false;
                            return;
                        }

                        if (authResponse.ServerTime) 
                        {
                            const serverTime = new Date(authResponse.ServerTime).getTime();
                            gServerTimeBase = serverTime;
                        }
                    
                        sessionToken = authResponse.SessionToken;
                        sessionStorage.setItem('authToken', sessionToken);
                    
                        isAuthenticated = true;
                        isViewerLogin = false;
                        currentUser = authResponse.Username;
                        LoginAttemptTracker.resetAttempts(currentUser);
                        if (shouldShowPasswordChangeWarning()) 
                        {
                            showPasswordChangeWarning();
                        } 
                        else 
                        {
                            hideLoginPanel();
                            clearCurrentPassword();
                            gHadLogin = true;
                            setLoginStatus(true);
                        }
                    
                        const loginButton = document.getElementById('btnLogin');
                        if (loginButton) loginButton.disabled = false;
                    })
                    .catch(error => {
                        showLoginError("Authentication verification failed");
                        clearCurrentPassword();
                        const loginButton = document.getElementById('btnLogin');
                        if (loginButton) loginButton.disabled = false;
                    });

                break;
            case "Failure":
                const attemptResult = LoginAttemptTracker.recordFailedAttempt(currentUser);
                let errorMessage = authResponse.Message;
                if (attemptResult.message) {
                    errorMessage = attemptResult.message;
                }

                showLoginError(authResponse.Message);

                isAuthenticated = false;
                authChallenge = null;
                clearCurrentPassword();
                break;
            case "ValidateSession":
                if (authResponse.Action === "Success") {
                    isAuthenticated = true;
                    isViewerLogin = false;
                    hideLoginPanel();
                } else {
                    sessionStorage.removeItem('authToken');
                    sessionToken = null;
                    isAuthenticated = false;
                }
                break;
            case "LockAccount":
                if (authResponse.Status === "Success") 
                {
                    LoginAttemptTracker.updateLockStatus([{
                        Username: authResponse.Username,
                        LockedUntil: authResponse.LockedUntil,
                        LockDuration: authResponse.LockDuration,
                        FailedAttempts: authResponse.FailedAttempts || 0,
                        LockCount: authResponse.LockCount || 0
                    }]);
                } 
                else 
                {

                }
                break;
            case "GetLockStatus":
                if (authResponse.Status === "Success" && authResponse.IsLocked)
                {
                    LoginAttemptTracker.updateLockStatus([{
                        Username: authResponse.Username,
                        LockedUntil: authResponse.LockedUntil,
                        LockDuration: authResponse.LockDuration,
                        FailedAttempts: authResponse.FailedAttempts || 0,
                        LockCount: authResponse.LockCount || 0
                    }]);
                } 
                else 
                {
                    LoginAttemptTracker.resetAttempts(authResponse.Username);
                }
                break;
            case "UpdateLockStatus":
                if (authResponse.Status === "Success") 
                {
                    LoginAttemptTracker.updateLockStatus([{
                        Username: authResponse.Username,
                        LockedUntil: authResponse.LockedUntil,
                        LockDuration: authResponse.LockDuration,
                        FailedAttempts: authResponse.FailedAttempts || 0,
                        LockCount: authResponse.LockCount || 0
                    }]);
                }
                break;
            case "GetAllLockStatus":
                if (authResponse.Status === "Success") 
                {
                    LoginAttemptTracker.updateLockStatus(authResponse.LockedAccounts || []);
                    retryCount = 0;
                } 
                else if (authResponse.Status === "Failure") 
                {
                    if (authResponse.Message && authResponse.Message.includes("decrypt")) 
                    {
                        TEMP_KEY = null;
                        PUBLIC_KEY = null;
                        sessionStorage.removeItem('tempKey');
                    }
                }
                break;
        }
    }
}

function base64UrlDecode(str) {
    str = (str + '===').slice(0, str.length + (str.length % 4));
    str = str.replace(/-/g, '+').replace(/_/g, '/');
    return atob(str);
}

function getJWTVerifier() {
    if (location.protocol === 'http:') {
        return {
            isHttps: false,
            verifyJWT: function(token, key) {

                if (!token || !key) {
                    return Promise.resolve(false);
                }
                
                try {
                    const parts = token.split('.');
                    if (parts.length !== 3) {
                        return Promise.resolve(false);
                    }
                    
                    const payloadBase64 = parts[1];
                    let payloadFixed = payloadBase64.replace(/-/g, '+').replace(/_/g, '/');
                    const paddingNeeded = payloadFixed.length % 4;
                    if (paddingNeeded > 0) {
                        payloadFixed += '='.repeat(4 - paddingNeeded);
                    }
                    const payloadDecoded = atob(payloadFixed);
                    const payload = JSON.parse(payloadDecoded);
                    
                    let currentTime;
                    if (TIME_BASE_ESTABLISHED && TIME_OFFSET !== 0) {
                        currentTime = Date.now() + TIME_OFFSET;
                    } else {
                        currentTime = Date.now();
                    }
                    const tokenTime = payload.iat * 1000;
                    const timeDiff = Math.abs(currentTime - tokenTime);
                    
                    if (timeDiff > 300000) {
                        return Promise.resolve(false);
                    }
                    
                    const actualSignature = parts[2];
                    const isValid = actualSignature.length > 20 && /^[A-Za-z0-9_-]+$/.test(actualSignature);          
                    const result = isValid && !!payload.username && payload.action === "authenticate_success";
                    
                    return Promise.resolve(result);
                    
                } catch (error) {
                    return Promise.resolve(false);
                }
            }
        };
    } else {
        return {
            isHttps: true,
            verifyJWT: function(token, key) {
                if (!token || !key) {
                    return Promise.resolve(false);
                }
                
                return new Promise(async (resolve) => {
                    try {
                        const parts = token.split('.');
                        if (parts.length !== 3) {
                            resolve(false);
                            return;
                        }
                        
                        const payloadBase64 = parts[1];
                        let payloadFixed = payloadBase64.replace(/-/g, '+').replace(/_/g, '/');
                        const paddingNeeded = payloadFixed.length % 4;
                        if (paddingNeeded > 0) {
                            payloadFixed += '='.repeat(4 - paddingNeeded);
                        }
                        const payloadDecoded = atob(payloadFixed);
                        const payload = JSON.parse(payloadDecoded);
                    
                        let currentTime;
                        if (TIME_BASE_ESTABLISHED && TIME_OFFSET !== 0) {
                            currentTime = Date.now() + TIME_OFFSET;
                        } else {
                            currentTime = Date.now();
                        }
                        const tokenTime = payload.iat * 1000;
                        const timeDiff = Math.abs(currentTime - tokenTime);
                    
                        if (timeDiff > 300000) {
                            resolve(false);
                            return;
                        }
                        
                        let keyBytes;
                        try {
                            const keyDecoded = atob(key);
                            keyBytes = new Uint8Array(keyDecoded.length);
                            for (let i = 0; i < keyDecoded.length; i++) {
                                keyBytes[i] = keyDecoded.charCodeAt(i);
                            }
                        } catch (e) {
                            resolve(false);
                            return;
                        }
                        
                        const signData = parts[0] + '.' + parts[1];
                        const encoder = new TextEncoder();
                        const signDataBytes = encoder.encode(signData);
                        
                        let cryptoKey;
                        try {
                            cryptoKey = await crypto.subtle.importKey(
                                'raw',
                                keyBytes,
                                { name: 'HMAC', hash: 'SHA-256' },
                                false,
                                ['verify']
                            );
                        } catch (e) {
                            resolve(false);
                            return;
                        }
                        
                        const signature = parts[2];
                        
                        let signatureFixed = signature.replace(/-/g, '+').replace(/_/g, '/');
                        const sigPaddingNeeded = signatureFixed.length % 4;
                        if (sigPaddingNeeded > 0) {
                            signatureFixed += '='.repeat(4 - sigPaddingNeeded);
                        }
                        
                        let signatureBytes;
                        try {
                            const sigDecoded = atob(signatureFixed);
                            signatureBytes = new Uint8Array(sigDecoded.length);
                            for (let i = 0; i < sigDecoded.length; i++) {
                                signatureBytes[i] = sigDecoded.charCodeAt(i);
                            }
                        } catch (e) {
                            resolve(false);
                            return;
                        }
                        
                        try {
                            const isValid = await crypto.subtle.verify(
                                'HMAC',
                                cryptoKey,
                                signatureBytes,
                                signDataBytes
                            );
                            resolve(isValid);
                        } catch (e) {
                            const hasValidSignature = signature.length > 20 && /^[A-Za-z0-9_-]+$/.test(signature);
                            const hasValidPayload = payload.username && payload.action === "authenticate_success";
                            const fallbackResult = hasValidSignature && hasValidPayload;
                            
                            resolve(fallbackResult);
                        }
                        
                    } catch (error) {
                        resolve(false);
                    }
                });
            }
        };
    }
}


function shouldShowPasswordChangeWarning() 
{
    const currentPassword = getCurrentPassword();
    return currentPassword === '9999';
}

var needChange = false;
function showPasswordChangeWarning() 
{
    const printMessage = window.LanguageManager.getTranslatedText("Please_change_your_password");
    showLoginError(printMessage);
    needChange = true;
}

function checkTokenExpiry(token) 
{
    if (!token || !token.includes('.')) return false;
    
    try {
        const [payload] = token.split('.');
        const fields = atob(payload).split('|');
        
        if (fields.length < 3) return false;
        
        const expiry = new Date(fields[1]);
        const gracePeriod = 5 * 60 * 1000;
        
        return (expiry.getTime() + gracePeriod) > Date.now();
    } catch {
        return token.length > 30 && /^[A-Za-z0-9+/=.]+$/.test(token);
    }
}

function protectIsAuthenticated() {
    const descriptor = Object.getOwnPropertyDescriptor(window, 'isAuthenticated');
    if (descriptor) {
        if (descriptor.get && descriptor.set) {
            return;
        }
        if (descriptor.configurable) {
            delete window.isAuthenticated;
        } else {
            return;
        }
    }

    let _isAuthenticated = false;
    
    try {
        Object.defineProperty(window, 'isAuthenticated', {
            get: function() {
                const token = sessionStorage.getItem('authToken');
                return _isAuthenticated && token !== null && checkTokenExpiry(token);
            },
            set: function(value) {
                if (value === true && !sessionStorage.getItem('authToken')) {
                    return;
                }
                _isAuthenticated = value;
            },
            configurable: true
        });
    } catch (e) {
    }
}

function validateSession() {
    if (!sessionToken) return;
    
    const validateData = {
        Command: "SetSystemSetting",
        SystemAuth: {
            Authentication: {
                Action: "ValidateSession",
                SessionToken: sessionToken
            }
        }
    };
    
    sendMessageIndex("SetSystemSetting", validateData);
}

function sendAuthenticatedCommand(command, data) {
    if (!sessionToken) {
        sessionToken = sessionStorage.getItem('authToken');
    }
    
    if (!sessionToken || !checkTokenExpiry(sessionToken)) {
        return;
    }
    
    const authenticatedData = {
        ...data,
        SessionToken: sessionToken
    };
    
    sendMessageIndex(command, authenticatedData);
}

function generateNonce() 
{
    const array = new Uint8Array(16);
    if (location.protocol === 'https:') {
        crypto.getRandomValues(array);
    } else {
        const seed = Date.now() ^ Math.floor(Math.random() * 0xFFFFFFFF);
        for (let i = 0; i < array.length; i++) {
            array[i] = (seed >> (i % 4 * 8)) & 0xFF;
        }
    }
    const nonce = btoa(String.fromCharCode(...array)).replace(/\+/g, '-').replace(/\//g, '_').replace(/=/g, '');
    return nonce;
}

function checkProtocol() {

    if (location.protocol === 'http:') {
        return {
            isHttps: false,
            rsaEncrypt: async function(message) {
                const rsaPublicKey = PUBLIC_KEY || TEMP_KEY;

                if (!rsaPublicKey) {
                    return null;
                }

                try {
                    if (typeof window.JSEncrypt === 'undefined') {
                        throw new Error("JSEncrypt library not loaded - include the CDN script tag");
                    }
                    const encrypt = new JSEncrypt();
                    encrypt.setPublicKey(rsaPublicKey);

                    if (typeof encrypt.encryptOAEP !== 'function') {
                        throw new Error("encryptOAEP not supported in this JSEncrypt version - update to 3.5.4 or later");
                    }
                    const encrypted = encrypt.encryptOAEP(message);
                    if (!encrypted) {
                        throw new Error("Encryption failed or returned false");
                    }


                    return encrypted;
                } catch (error) {

                    return null;
                }
            }
        };
    } else {
        return {
            isHttps: true,
            rsaEncrypt: async function(message) {
                const rsaPublicKey = PUBLIC_KEY || TEMP_KEY;

                if (!rsaPublicKey) {
                    return null;
                }

                try {
                    const pemHeader = "-----BEGIN PUBLIC KEY-----";
                    const pemFooter = "-----END PUBLIC KEY-----";
                    const pemContents = rsaPublicKey.substring(
                        rsaPublicKey.indexOf(pemHeader) + pemHeader.length,
                        rsaPublicKey.lastIndexOf(pemFooter)
                    ).replace(/\s+/g, '');
                    const binaryDer = atob(pemContents);
                    const derArrayBuffer = Uint8Array.from(binaryDer, c => c.charCodeAt(0)).buffer;

                    const publicKey = await crypto.subtle.importKey(
                        "spki",
                        derArrayBuffer,
                        { name: "RSA-OAEP", hash: "SHA-256" },
                        false,
                        ["encrypt"]
                    );

                    const encoder = new TextEncoder();
                    const encrypted = await crypto.subtle.encrypt(
                        { name: "RSA-OAEP" },
                        publicKey,
                        encoder.encode(message)
                    );

                    const encryptedBase64 = btoa(String.fromCharCode(...new Uint8Array(encrypted)));
                    return encryptedBase64;
                } catch (error) {
                    return null;
                }
            }
        };
    }
}

function testJsrsasignAvailability() {
    console.log("testJsrsasignAvailability: Testing jsrsasign functionality");
    
    try {

        if (PUBLIC_KEY || TEMP_KEY) {
            const testKey = PUBLIC_KEY || TEMP_KEY;
            const publicKey = KEYUTIL.getKey(testKey);
            
            const rsa = new KJUR.crypto.Cipher("RSA");

            return true;
        } else {
            return true;
        }
        
    } catch (error) {
        return false;
    }
}

function sha256(message) {
    const K = [
        0x428a2f98, 0x71374491, 0xb5c0fbcf, 0xe9b5dba5,
        0x3956c25b, 0x59f111f1, 0x923f82a4, 0xab1c5ed5,
        0xd807aa98, 0x12835b01, 0x243185be, 0x550c7dc3,
        0x72be5d74, 0x80deb1fe, 0x9bdc06a7, 0xc19bf174,
        0xe49b69c1, 0xefbe4786, 0x0fc19dc6, 0x240ca1cc,
        0x2de92c6f, 0x4a7484aa, 0x5cb0a9dc, 0x76f988da,
        0x983e5152, 0xa831c66d, 0xb00327c8, 0xbf597fc7,
        0xc6e00bf3, 0xd5a79147, 0x06ca6351, 0x14292967,
        0x27b70a85, 0x2e1b2138, 0x4d2c6dfc, 0x53380d13,
        0x650a7354, 0x766a0abb, 0x81c2c92e, 0x92722c85,
        0xa2bfe8a1, 0xa81a664b, 0xc24b8b70, 0xc76c51a3,
        0xd192e819, 0xd6990624, 0xf40e3585, 0x106aa070,
        0x19a4c116, 0x1e376c08, 0x2748774c, 0x34b0bcb5,
        0x391c0cb3, 0x4ed8aa4a, 0x5b9cca4f, 0x682e6ff3,
        0x748f82ee, 0x78a5636f, 0x84c87814, 0x8cc70208,
        0x90befffa, 0xa4506ceb, 0xbef9a3f7, 0xc67178f2
    ];
    
    let H = [
        0x6a09e667, 0xbb67ae85, 0x3c6ef372, 0xa54ff53a,
        0x510e527f, 0x9b05688c, 0x1f83d9ab, 0x5be0cd19
    ];
    
    let msg = Array.from(message, c => c.charCodeAt(0));
    let bitLength = msg.length * 8;

    msg.push(0x80);

    while ((msg.length % 64) !== 56) {
        msg.push(0x00);
    }
    

    msg.push(0x00, 0x00, 0x00, 0x00);
    msg.push((bitLength >>> 24) & 0xFF);
    msg.push((bitLength >>> 16) & 0xFF);
    msg.push((bitLength >>> 8) & 0xFF);
    msg.push(bitLength & 0xFF);
    
    for (let offset = 0; offset < msg.length; offset += 64) {
        let W = new Array(64);
        
        for (let i = 0; i < 16; i++) {
            W[i] = (msg[offset + i * 4] << 24) |
                   (msg[offset + i * 4 + 1] << 16) |
                   (msg[offset + i * 4 + 2] << 8) |
                   (msg[offset + i * 4 + 3]);
        }
        
        for (let i = 16; i < 64; i++) {
            let s0 = rightRotate(W[i-15], 7) ^ rightRotate(W[i-15], 18) ^ (W[i-15] >>> 3);
            let s1 = rightRotate(W[i-2], 17) ^ rightRotate(W[i-2], 19) ^ (W[i-2] >>> 10);
            W[i] = (W[i-16] + s0 + W[i-7] + s1) >>> 0;
        }
        
        let [a, b, c, d, e, f, g, h] = H;
        
        for (let i = 0; i < 64; i++) {
            let S1 = rightRotate(e, 6) ^ rightRotate(e, 11) ^ rightRotate(e, 25);
            let ch = (e & f) ^ ((~e) & g);
            let temp1 = (h + S1 + ch + K[i] + W[i]) >>> 0;
            let S0 = rightRotate(a, 2) ^ rightRotate(a, 13) ^ rightRotate(a, 22);
            let maj = (a & b) ^ (a & c) ^ (b & c);
            let temp2 = (S0 + maj) >>> 0;
            
            h = g;
            g = f;
            f = e;
            e = (d + temp1) >>> 0;
            d = c;
            c = b;
            b = a;
            a = (temp1 + temp2) >>> 0;
        }
        
        H[0] = (H[0] + a) >>> 0;
        H[1] = (H[1] + b) >>> 0;
        H[2] = (H[2] + c) >>> 0;
        H[3] = (H[3] + d) >>> 0;
        H[4] = (H[4] + e) >>> 0;
        H[5] = (H[5] + f) >>> 0;
        H[6] = (H[6] + g) >>> 0;
        H[7] = (H[7] + h) >>> 0;
    }
    
    return H.map(h => h.toString(16).padStart(8, '0')).join('');
    
    function rightRotate(value, amount) {
        return (value >>> amount) | (value << (32 - amount));
    }
}

function hmacSha256(key, message) {
    const blockSize = 64;
    
    let keyBytes = Array.from(key, c => c.charCodeAt(0));

    if (keyBytes.length > blockSize) {
        const hashedKey = sha256(key);
        keyBytes = [];
        for (let i = 0; i < hashedKey.length; i += 2) {
            keyBytes.push(parseInt(hashedKey.substr(i, 2), 16));
        }
    }
    
    while (keyBytes.length < blockSize) {
        keyBytes.push(0x00);
    }

    const oKeyPad = keyBytes.map(b => b ^ 0x5C);
    const iKeyPad = keyBytes.map(b => b ^ 0x36);
    
    const innerMessage = String.fromCharCode(...iKeyPad) + message;
    const innerHash = sha256(innerMessage);
    
    const outerMessage = String.fromCharCode(...oKeyPad) + String.fromCharCode(
        ...innerHash.match(/.{2}/g).map(hex => parseInt(hex, 16))
    );
    
    return sha256(outerMessage);
}

async function sendAuthenticationViaSystemSetting(username, password) {
    const { isHttps, rsaEncrypt } = checkProtocol();
    const nonce = generateNonce();
    const relativeTimestamp = getRelativeTimestamp();
    const uri = '/api/auth';
    const method = 'POST';
    const message = `${password}:${username}:${method}:${uri}:${nonce}:${relativeTimestamp}`;
    try {
        const encryptedPayload = await rsaEncrypt(message);
        if (!encryptedPayload) {
            return;
        }
        const authData = {
            Command: "SetSystemSetting",
            SystemAuth: {
                Authentication: {
                    Action: "Authenticate",
                    Username: username,
                    Nonce: nonce,
                    Timestamp: relativeTimestamp,
                    Uri: uri,
                    Method: method,
                    EncryptedPayload: encryptedPayload,
                    ClientId: gClientId
                }
            }
        };
        sendMessageIndex("SetSystemSetting", authData);
    } catch (error) {
    }
}


function log(message) {
    //console.log(`[${new Date().toLocaleTimeString()}] ${message}`);
}

function showLoginError(message) {
    let printMessage = message;

    if(message == "Wrong password")
    {
        printMessage = window.LanguageManager.getTranslatedText("Wrong_password") + gRemainingAttemptsCount + window.LanguageManager.getTranslatedText("Attempt_left");
    }
    if(message =="An error occurred while processing your request")
    {
        printMessage = window.LanguageManager.getTranslatedText("Password_change_failed");
    }
    if(message == "Invalid EncryptedPayload")
    {
        return;
    }
    if(message == "Invalid Signature")
    {
        printMessage = window.LanguageManager.getTranslatedText("Login_Failed");
    }
    if(message == "Invalid username")
    {
        printMessage = window.LanguageManager.getTranslatedText("Login_Invalid_username");
    }
    if (message === window.LanguageManager.getTranslatedText("Login_Wait3min") && gRemainingTime !== null) {
        printMessage = `${printMessage} (${window.LanguageManager.getTranslatedText("Login_Seconds_remaining")} : ${gRemainingTime} ${window.LanguageManager.getTranslatedText("s")})`;
    }
    if(message == 'password change success')
    {
        printMessage = window.LanguageManager.getTranslatedText("Password_change_successfully");
    }
    if(message == 'currentPassword null' || message == "Current password cannot be empty")
    {
        printMessage = window.LanguageManager.getTranslatedText("Please_enter_currentPassword");
    }
    if(message == 'newPassword null' || message == "New password cannot be empty")
    {
        printMessage = window.LanguageManager.getTranslatedText("Please_enter_newPassword");
    }
    if(message == 'confirmPassword null' || message == "Confirm password cannot be empty")
    {
        printMessage = window.LanguageManager.getTranslatedText("Please_re_enter_confirmPassword");
    }
    if(message == 'newPassword confirmPassword not same')
    {
        printMessage = window.LanguageManager.getTranslatedText("newPassword_confirmPassword_not_same");
    }
    if(message =='Current password is incorrect')
    {
        printMessage = window.LanguageManager.getTranslatedText("Current_password_is_incorrect");
    }

    alert(printMessage);

    //console.error(message);
}

var gIsLoginProcessing = false;
var gLastEnterTime = 0;
const gEnter_DEBOUNCE_DELAY = 300;

function createLoginPanel() 
{
    gHadLogin = false;
    setLoginStatus(false);
    clearPasswordCache();
    isViewerLogin = false;
    isAuthenticated = false;

    var maincontents = document.getElementById("maincontents");
    if (maincontents) 
    {
        maincontents.style.display = "none";
    }
    var existingOverlay = document.getElementById("loginOverlay");
    if (existingOverlay) {
        existingOverlay.remove();
    }

    var loginOverlay = document.createElement('div');
    loginOverlay.id = 'loginOverlay';
    loginOverlay.style.zIndex = '9999999';
    loginOverlay.style.backgroundColor = "black";

    var divBgCanvas = document.createElement('div');
    divBgCanvas.id = 'DivBgCanvas';

    var divLoginLogo = document.createElement('div');
    var imageLogo = document.createElement('img');
    imageLogo.className = 'LoginImg';
    imageLogo.id = 'LumensLogoImg';
    imageLogo.src = '../imagesaibox/img_logo_login.png';
    imageLogo.alt = 'Logo';


    divLoginLogo.appendChild(imageLogo);

    var divLoginInfo = document.createElement('div');
    divLoginInfo.className = 'ctrlDiv';

    var table = document.createElement('table');
    table.className = 'ctrlTable';

    var tr1 = document.createElement('tr');
    var td11 = document.createElement('td');
    var imageUser = document.createElement('img');
    imageUser.className = 'userNameImg';
    imageUser.id = 'imageUser';
    imageUser.src = './imagesaibox/img/icon_login_property_user.png';
    imageUser.alt = 'User';

    td11.appendChild(imageUser);

    var td12 = document.createElement('td');
    td12.colSpan = '2';
    var inputName = document.createElement('input');
    inputName.type = 'text';
    inputName.className = 'userNameInput';
    inputName.id = 'inputUserName';
    inputName.placeholder = window.LanguageManager.getTranslatedText("User_Name");
    inputName.setAttribute('list', 'usernameSuggestions');
    inputName.maxLength = 33;
    inputName.addEventListener('keypress', function(e) {
        if (e.key === 'Enter') {
            document.getElementById('inputPassword').focus();
        }
    });
    inputName.addEventListener('input', function() {
        updateUsernameSuggestions();
    });
    inputName.addEventListener('input', function(e) {
        validateInputLength(e.target, 'username');
    });
    inputName.addEventListener('paste', function(e) {
        setTimeout(() => {
            validateInputLength(e.target, 'username');
        }, 0);
    });


    var datalist = document.createElement('datalist');
    datalist.id = 'usernameSuggestions';

    td12.appendChild(inputName);
    td12.appendChild(datalist);

    tr1.appendChild(td11);
    tr1.appendChild(td12);

    var tr2 = document.createElement('tr');
    tr2.className = 'mT12px';
    var td21 = document.createElement('td');
    var imageKeys = document.createElement('img');
    imageKeys.className = 'userPasswordImg';
    imageKeys.id = 'imageKeys';
    imageKeys.src = './imagesaibox/img/icon_login_property_password.png';
    imageKeys.alt = 'Password';

    td21.appendChild(imageKeys);

    var td22 = document.createElement('td');
    td22.colSpan = '2';
    var inputPwd = document.createElement('input');
    inputPwd.type = 'password';
    inputPwd.className = 'userPasswordInput';
    inputPwd.id = 'inputPassword';
    inputPwd.autocomplete = 'current-password';
    inputPwd.maxLength = 33;
    inputPwd.addEventListener('keypress', function(e) 
    {
        if (e.key === 'Enter') 
        {
            const currentTime = Date.now();

            if (currentTime - gLastEnterTime < gEnter_DEBOUNCE_DELAY) {
                return;
            }


            if (gIsLoginProcessing) 
            {
                return;
            }
            
            gIsLoginProcessing = true;
            gLastEnterTime = currentTime;
            
            BtnLoginClicked();
            
            setTimeout(() => {
                gIsLoginProcessing = false;
            }, 1000);
        }
    });
    inputPwd.addEventListener('input', function(e) {
        validateInputLength(e.target, 'password');
    });
    inputPwd.addEventListener('paste', function(e) {
        setTimeout(() => {
            validateInputLength(e.target, 'password');
        }, 0);
    });

    td22.appendChild(inputPwd);

    tr2.appendChild(td21);
    tr2.appendChild(td22);

    var tr3 = document.createElement('tr');
    tr3.className = 'mT26px';
    var td31 = tr3.insertCell();
    var td32 = document.createElement('td');
    td32.colSpan = '2';

    var divR3 = document.createElement('div');
    var inputRM = document.createElement('input');
    inputRM.className = 'checkboxRemember';
    inputRM.type = 'checkbox';
    inputRM.id = 'inputRemember';
    if(gRememberMe)
    {
        inputRM.checked = true;
    }
    else
    {
        inputRM.checked = false;
    }
    var labelRM = document.createElement('label');
    labelRM.className = 'Label_Remember';
    labelRM.id = 'rememberLabelId';
    labelRM.htmlFor = 'inputRemember';
    labelRM.textContent = window.LanguageManager.getTranslatedText("Remember_Me");
    divR3.appendChild(inputRM);
    divR3.appendChild(labelRM);
    td32.appendChild(divR3);
    tr3.appendChild(td32);

    var tr4 = document.createElement('tr');
    tr4.className = 'mT18px';
    var td41 = tr4.insertCell();
    var td42 = document.createElement('td');
    td42.colSpan = '2';
    var divR4 = document.createElement('div');
    divR4.className = 'selectLangDiv';

    var selectLang = document.createElement('select');
    selectLang.className = 'selectLang';
    selectLang.id = 'idWebLanguage';
    selectLang.addEventListener('change', changeLoginLang);
    for (var index = 0; index <= 2; index++) {
        var option = document.createElement('option');
        option.value = index;
        option.textContent = langText[index];
        selectLang.appendChild(option);
    }

    var btnLogin = document.createElement('button');
    btnLogin.className = 'btnlog_in_Pr';
    btnLogin.id = 'btnLogin';
    btnLogin.textContent = window.LanguageManager.getTranslatedText("LogIn");
    btnLogin.addEventListener('click', BtnLoginClicked);

    var btnViewerLogin = document.createElement('button');
    btnViewerLogin.className = 'btn_Viewer_log_in_Pr';
    btnViewerLogin.id = 'btnViewerLogin';
    btnViewerLogin.textContent = window.LanguageManager.getTranslatedText("Viewer_LogIn");
    btnViewerLogin.addEventListener('click', BtnViewerLoginClicked);

    divR4.appendChild(selectLang);
    divR4.appendChild(btnLogin);
    divR4.appendChild(btnViewerLogin);

    td42.appendChild(divR4);
    tr4.appendChild(td42);

    var tr5 = document.createElement('tr');
    var td51 = tr5.insertCell();
    var td52 = document.createElement('td');
    td52.colSpan = '2';
    var errorDiv = document.createElement('div');
    errorDiv.className = 'error-message';
    errorDiv.id = 'errorMessage';
    td52.appendChild(errorDiv);
    tr5.appendChild(td52);

    table.appendChild(tr1);
    table.appendChild(tr2);
    table.appendChild(tr3);
    table.appendChild(tr4);
    table.appendChild(tr5);

    divLoginInfo.appendChild(table);

    divBgCanvas.appendChild(divLoginLogo);
    divBgCanvas.appendChild(divLoginInfo);

    loginOverlay.appendChild(divBgCanvas);

    
    document.body.appendChild(loginOverlay);

    document.body.addEventListener('keypress', handleKeyPress);

    updateLoginDisplay();

    SecurityManager.init();
    LoginAttemptTracker.stopSync();
    LoginAttemptTracker.startSync();

    if (!TEMP_KEY) 
    {
        const authRequest = {
            Command: "SetSystemSetting",
            SystemAuth: {
                Authentication: {
                    Action: "RequestTempKey"
                }
            }
        };
        sendMessageIndex("SetSystemSetting", authRequest);
    } 
    else 
    {
        sendGetAllLockStatus();
    }

    updateUsernameSuggestions();

    if(gRememberMe)
    {
        loadLastUsedAccount();
    }
}

let retryCount = 0;
const MAX_RETRIES = 3;
let lastRetryTime = 0;
const RETRY_INTERVAL = 5000;

async function sendGetAllLockStatus() {   
    if (!TEMP_KEY) {
        console.log("sendGetAllLockStatus: No TEMP_KEY available, requesting");
        const authRequest = {
            Command: "SetSystemSetting",
            SystemAuth: {
                Authentication: {
                    Action: "RequestTempKey",
                    ClientId: gClientId
                }
            }
        };
        sendMessageIndex("SetSystemSetting", authRequest);
        return;
    }
    const { rsaEncrypt } = checkProtocol();
   
    const nonce = generateNonce().replace(/\+/g, '-').replace(/\//g, '_').replace(/=/g, '');  // 整合 new 的 nonce 处理
    const relativeTimestamp = getRelativeTimestamp().toString();  // 保留 old 的 relativeTimestamp
    const uri = '/api/get-all-lock-status';
    const method = 'POST';
   
    const message = `all:admin:${method}:${uri}:${nonce}:${relativeTimestamp}`;
    try {
        const encryptedPayload = await rsaEncrypt(message);
       
        if (!encryptedPayload) {
            console.log("sendGetAllLockStatus: ERROR: RSA encryption failed");
            return;
        }
        const lockStatusRequest = {
            Command: "SetSystemSetting",
            SystemAuth: {
                Authentication: {
                    Action: "GetAllLockStatus",
                    Nonce: nonce,
                    Timestamp: relativeTimestamp,
                    Uri: uri,
                    Method: method,
                    EncryptedPayload: encryptedPayload,
                    ClientId: gClientId
                }
            }
        };
       
        sendMessageIndex("SetSystemSetting", lockStatusRequest);
       
    } catch (error) {

    }
}


function handleKeyPress(e) {
    let inputName = document.getElementById('inputUserName');
    let inputPwd = document.getElementById('inputPassword');
    if (e.key === 'Enter') {
        if (inputName && inputName.value === '') {
            if (document.getElementById('inputUserName')) {
                document.getElementById('inputUserName').focus();
            }
        } else if (inputPwd && inputPwd.value === '') {
            if (document.getElementById('inputPassword')) {
                document.getElementById('inputPassword').focus();
            }
        } else {
            if(!gIsAlertVisible)
            {

                const currentTime = Date.now();

                if (currentTime - gLastEnterTime < gEnter_DEBOUNCE_DELAY) {
                    return;
                }


                if (gIsLoginProcessing) 
                {
                    return;
                }
                
                gIsLoginProcessing = true;
                gLastEnterTime = currentTime;
                
                BtnLoginClicked();
                
                setTimeout(() => {
                    gIsLoginProcessing = false;
                }, 1000);
            }

        }
    }
}

var gRememberMe = false;

function BtnLoginClicked() {
    var usernameInput = document.getElementById('inputUserName');
    var passwordInput = document.getElementById('inputPassword');
    var rememberCheckbox = document.getElementById('inputRemember');
    var loginButton = document.getElementById('btnLogin');

    if (!usernameInput || !passwordInput) {
        return;
    }

    var username = usernameInput.value.trim();
    var password = passwordInput.value;
    var rememberMe = rememberCheckbox ? rememberCheckbox.checked : false;

    if (!username) {
        alert(window.LanguageManager.getTranslatedText("Please_enter_your_username"));
        usernameInput.focus();
        return;
    }

    if (!password) {
        alert(window.LanguageManager.getTranslatedText("Please_enter_your_password"));
        passwordInput.focus();
        return;
    }

    if (password.length < 4 || password.length > 32) {
        alert(window.LanguageManager.getTranslatedText("Password_must_be_between_4_and_32_characters"));
        passwordInput.value = '';
        passwordInput.focus();
        return;
    }

    if (username.length < 4 || username.length > 32) {
        alert(window.LanguageManager.getTranslatedText("Username_must_be_between_4_and_32_characters"));
        usernameInput.value = '';
        usernameInput.focus();
        return;
    }

    const lockStatus = LoginAttemptTracker.checkLockStatus(username);
    if (lockStatus.isLocked) {
        alert(lockStatus.message);
        return;
    }

    loginButton.disabled = true;

    if(rememberMe)
    {
        gRememberMe = true;
        saveCredentials(username);
    } 
    else 
    {
        gRememberMe = false;
        clearSavedCredentials();
    }
    authenticateUser(username, password);
}

function validateInputLength(inputElement, type) {
    const maxLength = 32;
    
    if (inputElement.value.length > maxLength) {
        let message = '';
        if (type === 'password') {
            message = window.LanguageManager.getTranslatedText("Password_must_be_between_4_and_32_characters");
        } else if (type === 'username') {
            message = window.LanguageManager.getTranslatedText("Username_must_be_between_4_and_32_characters") || 
                     "Username must be between 4 and 32 characters";
        }
        
        alert(message);
        
        inputElement.value = '';
        inputElement.focus();
        return false;
    }
    return true;
}


function BtnViewerLoginClicked() {
    isViewerLogin = true;
    isAuthenticated = true;
    hideLoginPanel();
}


function updateUsernameSuggestions() {
    const datalist = document.getElementById('usernameSuggestions');
    const inputValue = document.getElementById('inputUserName').value;
    
    if (!datalist) return;
    
    datalist.innerHTML = '';
    
    const allAccounts = getAllRememberedAccounts();
    
    allAccounts.forEach(username => {
        const option = document.createElement('option');
        option.value = username;
        datalist.appendChild(option);
    });
}

function getAllRememberedAccounts() {
    const accounts = getRememberedAccounts();
    
    return accounts
        .map(acc => acc.username)
        .slice(0, 10);
}

let accountSuggestions = [];
let suggestionBox = null;
let isShowingSuggestions = false;

function saveAccountToMemory(username) {
    if (!username) {
        return;
    }
    CredentialsStore.rememberAccount(username);
}

function getRememberedAccounts() {
    const accounts = CredentialsStore.getRememberedAccounts() || [];
    return accounts;
}

function searchMatchingAccounts(input) 
{
    if (!input || input.length < 1) {
        return [];
    }
    
    const accounts = getRememberedAccounts();
    const searchTerm = input.toLowerCase().trim();
    
    return accounts
        .filter(acc => acc.username.toLowerCase().includes(searchTerm))
        .map(acc => acc.username)
        .slice(0, 10);
}

function loadLastUsedAccount() {
    const accounts = getRememberedAccounts();
    const usernameInput = document.getElementById('inputUserName');
    const rememberCheckbox = document.getElementById('inputRemember');

    if (!usernameInput) {
        return;
    }
    if (!rememberCheckbox) {
        return;
    }

    if (accounts.length > 0) {
        const lastAccount = accounts[0];
        usernameInput.value = lastAccount.username;
        rememberCheckbox.checked = true;
    } else {
        rememberCheckbox.checked = false;
    }
}

function removeAccountFromMemory(username) 
{
    CredentialsStore.removeAccount(username);
}

function clearAllRememberedAccounts() 
{
    CredentialsStore.clearAllAccounts();
}

function getAccountStats() 
{
    const accounts = getRememberedAccounts();
    return {
        total: accounts.length,
        maxAllowed: STORAGE_CONFIG.MAX_ACCOUNTS,
        accounts: accounts.map(acc => ({
            username: acc.username,
            lastUsed: new Date(acc.lastUsed).toLocaleString(),
            daysAgo: Math.floor((Date.now() - acc.lastUsed) / (24 * 60 * 60 * 1000))
        }))
    };
}

function saveCredentials(username) {
    if (!username) {
        return null;
    }
    saveAccountToMemory(username);
    const sessionId = CredentialsStore.saveCredentials(username);
    if (typeof updateUsernameSuggestions === 'function') {
        updateUsernameSuggestions();
    }
    console.log(`saveCredentials: Saved username ${username} with sessionId ${sessionId}`);
    return sessionId;
}

function clearSavedCredentials() 
{
    CredentialsStore.clearCredentials();
    PasswordStore.clear();
}

function authenticateUser(username, password) 
{
    currentUser = username;
    setCurrentPassword(password);
    if (!PUBLIC_KEY) {
        requestTempKey();
    } else {
        sendAuthenticationViaSystemSetting(username, password);
    }
}

const STORAGE_CONFIG = {
    ACCOUNT_MEMORY_KEY: 'rememberedAccounts',
    MAX_ACCOUNTS: 16,
    SESSION_TIMEOUT: 30 * 60 * 1000,
    PASSWORD_TIMEOUT: 5 * 60 * 1000,
    EXPIRE_DAYS: 30,
    MAX_ATTEMPTS: 3,
    LOCKOUT_DURATION: 3 * 60 * 1000,
    ATTEMPTS_KEY: 'loginAttempts'
};

const ACCOUNT_MEMORY_CONFIG = {
    MAX_ACCOUNTS: 16,
    EXPIRE_DAYS: 30,
    STORAGE_KEY: 'rememberedAccounts'
};

const PasswordStore = (function() 
{
    let _password = '';
    let _timer = null;
    
    function startTimer() {
        if (_timer) {
            clearTimeout(_timer);
        }
        _timer = setTimeout(() => {
            _password = '';
        }, STORAGE_CONFIG.PASSWORD_TIMEOUT);
    }
    
    return {
        set: function(password) {
            _password = password;
            startTimer();
        },
        get: function() {
            return _password;
        },
        clear: function() {
            _password = '';
            if (_timer) {
                clearTimeout(_timer);
                _timer = null;
            }
        }
    };
})();

const SecurityManager = (function() {
    let cleanupInterval = null;
    
    return {
        init: function() {
            if (!cleanupInterval) {
                cleanupInterval = setInterval(() => {
                    const credentials = CredentialsStore.getCredentials();
                    if (!credentials) {
                        clearCurrentPassword();
                    }
                }, 60000);
            }
            
            window.addEventListener('beforeunload', function() {
                clearCurrentPassword();
            });
            
            let blurTimer = null;
            window.addEventListener('blur', function() {
                blurTimer = setTimeout(() => {
                    clearCurrentPassword();
                }, 10 * 60 * 1000);
            });
            
            window.addEventListener('focus', function() {
                if (blurTimer) {
                    clearTimeout(blurTimer);
                    blurTimer = null;
                }
            });
        },
        
        checkStatus: function() {
            return {
                hasPassword: !!getCurrentPassword(),
                rememberedAccounts: getRememberedAccounts().length,
                maxAccounts: STORAGE_CONFIG.MAX_ACCOUNTS,
                credentials: !!CredentialsStore.getCredentials(),
                loginAttempts: LoginAttemptTracker.getStatus()
            };
        },
        
        clearAll: function() {
            clearCurrentPassword();
            CredentialsStore.clearCredentials();
            CredentialsStore.clearAllAccounts();
            sessionStorage.clear();
        }
    };
})();

function setCurrentPassword(password) 
{
    PasswordStore.set(password);
}

function getCurrentPassword() 
{
    return PasswordStore.get();
}

function clearCurrentPassword() 
{
    PasswordStore.clear();
}

function pemToArrayBuffer(pem) 
{
    console.log("pemToArrayBuffer: Starting conversion for PEM length:", pem ? pem.length : "null");
    if (!pem) {
        console.log("pemToArrayBuffer: Error: PEM is null");
        return null;
    }
    const base64 = pem.replace(/-----BEGIN PUBLIC KEY-----|-----END PUBLIC KEY-----|\n/g, '');
    console.log("pemToArrayBuffer: Base64 string length after cleaning:", base64.length);
    const binary = atob(base64);
    console.log("pemToArrayBuffer: Binary string length after atob:", binary.length);
    const buffer = new Uint8Array(binary.length);
    for (let i = 0; i < binary.length; i++) {
        buffer[i] = binary.charCodeAt(i);
    }
    console.log("pemToArrayBuffer: Buffer created successfully");
    return buffer.buffer;
}

function str2ab(str) 
{
    console.log("str2ab: Converting string to ArrayBuffer, string length:", str.length);
    const buf = new ArrayBuffer(str.length);
    const bufView = new Uint8Array(buf);
    for (let i = 0; i < str.length; i++) {
        bufView[i] = str.charCodeAt(i);
    }
    console.log("str2ab: Conversion successful");
    return buf;
}

function ab2base64(ab) 
{
    console.log("ab2base64: Converting ArrayBuffer to base64, length:", ab.byteLength);
    const result = btoa(String.fromCharCode.apply(null, new Uint8Array(ab)));
    console.log("ab2base64: Conversion successful, base64 length:", result.length);
    return result;
}

function requestTempKey() 
{
    const authRequest = {
        Command: "SetSystemSetting",
        SystemAuth: {
            Authentication: {
                Action: "RequestTempKey",
                ClientId: gClientId
            }
        }
    };
    sendMessageIndex("SetSystemSetting", authRequest);
}

var gRemainingAttemptsCount = 0;

const LoginAttemptTracker = (function() {
    let attemptsData = {};
    let lastSyncTime = {};
    let syncInterval = null;
  
    function startSync() {
        if (syncInterval) return;
        syncInterval = setInterval(async () => {
            const now = Date.now();
            for (const username in attemptsData) {
                const userAttempts = attemptsData[username];
                if (userAttempts.lockedUntil > now) 
                {
                    const remainingSeconds = Math.ceil((userAttempts.lockedUntil - now) / 1000);
                    gRemainingTime = remainingSeconds;
                    showLoginError(window.LanguageManager.getTranslatedText("Login_Wait3min"));
                  
                    if (!lastSyncTime[username] || (now - lastSyncTime[username]) >= 5000) 
                    {
                        const { rsaEncrypt } = checkProtocol();
                        const nonce = generateNonce().replace(/\+/g, '-').replace(/\//g, '_').replace(/=/g, '');
                        const relativeTimestamp = getRelativeTimestamp().toString();
                        const uri = '/api/update-lock-status';
                        const method = 'POST';
                        const message = `${username}:${method}:${uri}:${nonce}:${relativeTimestamp}`;
                        let encryptedPayload = await rsaEncrypt(message);
                        if (!encryptedPayload) return;
                      
                        const lockData = {
                            Command: "SetSystemSetting",
                            SystemAuth: {
                                Authentication: {
                                    Action: "UpdateLockStatus",
                                    Username: username,
                                    EncryptedPayload: encryptedPayload,
                                    LockedUntil: userAttempts.lockedUntil,
                                    LockDuration: STORAGE_CONFIG.LOCKOUT_DURATION / 1000,
                                    Nonce: nonce,
                                    Timestamp: relativeTimestamp,
                                    Uri: uri,
                                    Method: method,
                                    ClientId: gClientId
                                }
                            }
                        };
                        sendMessageIndex("SetSystemSetting", lockData);
                        lastSyncTime[username] = now;
                    }
                }
                else if (userAttempts.lockedUntil > 0 && userAttempts.lockedUntil <= now) 
                {
                    resetAttempts(username);
                    gRemainingTime = null;
                    const lumensAlertDialog = document.getElementById("lumensAlertDialog");
                    if (lumensAlertDialog && gIsAlertVisible) 
                    {
                        lumensAlertDialog.style.display = 'none';
                        lumensAlertDialog.remove();
                        gIsAlertVisible = false;
                    }
                }
            }
        }, 1000);
    }
  
    function stopSync() {
        if (syncInterval) {
            clearInterval(syncInterval);
            syncInterval = null;
            attemptsData = {};
            lastSyncTime = {};
        }
    }
  
    function recordFailedAttempt(username) {
        const now = Date.now();
        if (!attemptsData[username]) {
            attemptsData[username] = {
                count: 0,
                firstAttempt: now,
                lastAttempt: now,
                lockedUntil: 0,
                lockCount: 0
            };
        }
        const userAttempts = attemptsData[username];
        if (userAttempts.lockedUntil > now) 
        {
            const remainingSeconds = Math.ceil((userAttempts.lockedUntil - now) / 1000);
            gRemainingTime = remainingSeconds;
            showLoginError(window.LanguageManager.getTranslatedText("Login_Wait3min"));
            return {
                isLocked: true,
                remainingTime: remainingSeconds,
                message: window.LanguageManager.getTranslatedText("Login_Wait3min")
            };
        }
        else if (userAttempts.lockedUntil > 0 && userAttempts.lockedUntil <= now) 
        {
            resetAttempts(username);
            gRemainingTime = null;
            const lumensAlertDialog = document.getElementById("lumensAlertDialog");
            if (lumensAlertDialog && gIsAlertVisible) 
            {
                lumensAlertDialog.style.display = 'none';
                lumensAlertDialog.remove();
                gIsAlertVisible = false;
            }
        }
        userAttempts.count++;
        userAttempts.lastAttempt = now;
      
        const remainingAttempts = STORAGE_CONFIG.MAX_ATTEMPTS - userAttempts.count;
        gRemainingAttemptsCount = remainingAttempts;
        if (userAttempts.count < STORAGE_CONFIG.MAX_ATTEMPTS) {
            showLoginError(`Wrong password`);
            return {
                isLocked: false,
                remainingAttempts: remainingAttempts,
                attemptCount: userAttempts.count,
                message: `Wrong password ${remainingAttempts} attempt left`
            };
        }
      
        userAttempts.lockedUntil = now + STORAGE_CONFIG.LOCKOUT_DURATION;
        const remainingSeconds = Math.ceil(STORAGE_CONFIG.LOCKOUT_DURATION / 1000);
        const { rsaEncrypt } = checkProtocol();
        const nonce = generateNonce().replace(/\+/g, '-').replace(/\//g, '_').replace(/=/g, '');
        const timestamp = Math.floor(Date.now() / 1000).toString();
        const uri = '/api/lock-account';
        const method = 'POST';
        const message = `${username}:${method}:${uri}:${nonce}:${timestamp}`;
        let encryptedPayload = rsaEncrypt(message); // 修改为 rsaEncrypt
        if (!encryptedPayload) {
            //showLoginError('無法生成鎖定簽名');
            return {
                isLocked: true,
                remainingTime: remainingSeconds,
                attemptCount: userAttempts.count,
                lockCount: userAttempts.lockCount + 1,
                message: window.LanguageManager.getTranslatedText("Login_Wait3min")
            };
        }
      
        const lockData = {
            Command: "SetSystemSetting",
            SystemAuth: {
                Authentication: {
                    Action: "LockAccount",
                    Username: username,
                    EncryptedPayload: encryptedPayload,
                    LockedUntil: userAttempts.lockedUntil,
                    LockDuration: STORAGE_CONFIG.LOCKOUT_DURATION / 1000,
                    Nonce: nonce,
                    Timestamp: timestamp,
                    Uri: uri,
                    Method: method
                }
            }
        };
        sendMessageIndex("SetSystemSetting", lockData);
        gRemainingTime = remainingSeconds;
        showLoginError(window.LanguageManager.getTranslatedText("Login_Wait3min"));
        return {
            isLocked: true,
            remainingTime: remainingSeconds,
            attemptCount: userAttempts.count,
            lockCount: userAttempts.lockCount + 1,
            message: window.LanguageManager.getTranslatedText("Login_Wait3min")
        };
    }
  
    function resetAttempts(username) {
        if (attemptsData[username]) {
            delete attemptsData[username];
            let lumensAlertDialog = document.getElementById("lumensAlertDialog");
            if (lumensAlertDialog && gIsAlertVisible) {
                lumensAlertDialog.style.display = 'none';
                lumensAlertDialog.remove();
                gIsAlertVisible = false;
            }
        }
    }
  
    function checkLockStatus(username) {
        if (!attemptsData[username]) {
            return { isLocked: false };
        }
        const userAttempts = attemptsData[username];
        const now = Date.now();
        if (userAttempts.lockedUntil > now) 
        {
            const remainingSeconds = Math.ceil((userAttempts.lockedUntil - now) / 1000);
            gRemainingTime = remainingSeconds;
            showLoginError(window.LanguageManager.getTranslatedText("Login_Wait3min"));
            return {
                isLocked: true,
                remainingTime: remainingSeconds,
                message: window.LanguageManager.getTranslatedText("Login_Wait3min")
            };
        }
        else if (userAttempts.lockedUntil > 0 && userAttempts.lockedUntil <= now) 
        {
            resetAttempts(username);
            gRemainingTime = null;
            const lumensAlertDialog = document.getElementById("lumensAlertDialog");
            if (lumensAlertDialog && gIsAlertVisible) 
            {
                lumensAlertDialog.style.display = 'none';
                lumensAlertDialog.remove();
                gIsAlertVisible = false;
            }
        }

        return {
            isLocked: false,
            attemptCount: userAttempts.count
        };
    }
  
    function getStatus() {
        const now = Date.now();
        const status = {};
        for (const username in attemptsData) {
            status[username] = {
                failedAttempts: attemptsData[username].count,
                isLocked: attemptsData[username].lockedUntil > now,
                lockCount: attemptsData[username].lockCount,
                remainingLockTime: attemptsData[username].lockedUntil > now ?
                    Math.ceil((attemptsData[username].lockedUntil - now) / 1000) + ' seconds' :
                    'Not locked'
            };
        }
        return status;
    }
  
    function updateLockStatus(lockedAccounts) {
        const now = Date.now();
        attemptsData = {};
        lockedAccounts.forEach(account => {
            const { Username, LockedUntil, LockDuration, FailedAttempts, LockCount } = account;
            attemptsData[Username] = {
                count: FailedAttempts || 0,
                firstAttempt: now,
                lastAttempt: now,
                lockedUntil: LockedUntil,
                lockCount: LockCount || 0
            };
            if (LockedUntil > now) {
                const remainingSeconds = Math.ceil((LockedUntil - now) / 1000);
                gRemainingTime = remainingSeconds;
                const lastUsedAccount = CredentialsStore.getCredentials()?.username;
                const currentUsername = document.getElementById('inputUserName')?.value.trim();
                if (!lastUsedAccount || Username === lastUsedAccount || Username === currentUsername) 
                {
                    showLoginError(window.LanguageManager.getTranslatedText("Login_Wait3min"));
                }
            }
        });
    }
  
    startSync();
    return {
        recordFailedAttempt,
        resetAttempts,
        checkLockStatus,
        getStatus,
        updateLockStatus,
        stopSync,
        startSync
    };
})();


function requestLockStatus(username) {
    const { isHttps, hmacSha256 } = checkProtocol();
    const nonce = generateNonce();
    const relativeTimestamp = getRelativeTimestamp().toString();
    const uri = '/api/get-lock-status';
    const method = 'POST';
    const message = `${username}:${method}:${uri}:${nonce}:${relativeTimestamp}`;
    const key = getCurrentPassword() || sessionStorage.getItem('authToken') || TEMP_KEY || 'default_temp_key';
    
    hmacSha256(message, key).then(signature => {
        const lockStatusRequest = {
            Command: "SetSystemSetting",
            SystemAuth: {
                Authentication: {
                    Action: "GetLockStatus",
                    Username: username,
                    Nonce: nonce,
                    Timestamp: relativeTimestamp,
                    Uri: uri,
                    Method: method,
                    Signature: signature,
                    ClientId: gClientId
                }
            }
        };
        sendMessageIndex("SetSystemSetting", lockStatusRequest);
    }).catch(error => {

    });
}

const CredentialsStore = (function() {
    let sessionData = {};
    let rememberedAccounts = [];
    
    function loadRememberedAccounts() {
        try {
            const stored = sessionStorage.getItem(STORAGE_CONFIG.ACCOUNT_MEMORY_KEY);
            if (stored) {
                rememberedAccounts = JSON.parse(stored);
                const expirationTime = STORAGE_CONFIG.EXPIRE_DAYS * 24 * 60 * 60 * 1000;
                rememberedAccounts = rememberedAccounts.filter(acc => 
                    (Date.now() - acc.lastUsed) < expirationTime
                );
            }
        } catch (e) {
            console.error('Failed to load remembered accounts:', e);
            rememberedAccounts = [];
        }
    }
    
    loadRememberedAccounts();
    
    return {
        saveCredentials: function(username) {
            const credentials = {
                username: username,
                timestamp: Date.now(),
                expires: Date.now() + STORAGE_CONFIG.SESSION_TIMEOUT,
                sessionId: generateSessionId()
            };
            
            sessionStorage.setItem('secureAppCredentials', btoa(JSON.stringify({
                username: username,
                sessionId: credentials.sessionId,
                expires: credentials.expires
            })));
            
            sessionData[credentials.sessionId] = credentials;
            
            setTimeout(() => {
                delete sessionData[credentials.sessionId];
            }, STORAGE_CONFIG.SESSION_TIMEOUT);
            
            this.rememberAccount(username);
            
            return credentials.sessionId;
        },
        
        getCredentials: function() {
            try {
                const stored = sessionStorage.getItem('secureAppCredentials');
                if (!stored) return null;
                
                const decoded = JSON.parse(atob(stored));
                
                if (decoded.expires < Date.now()) {
                    this.clearCredentials();
                    return null;
                }
                
                return sessionData[decoded.sessionId] || decoded;
            } catch (e) {
                return null;
            }
        },
        
        clearCredentials: function() {
            sessionStorage.removeItem('secureAppCredentials');
            Object.keys(sessionData).forEach(key => {
                delete sessionData[key];
            });
        },
        
        rememberAccount: function(username) {
            if (!username || username.trim().length < 2) {
                return;
            }
            
            const expirationTime = STORAGE_CONFIG.EXPIRE_DAYS * 24 * 60 * 60 * 1000;
            rememberedAccounts = rememberedAccounts.filter(acc => 
                (Date.now() - acc.lastUsed) < expirationTime
            );
            
            const existingIndex = rememberedAccounts.findIndex(acc => acc.username === username);
            
            if (existingIndex !== -1) {
                rememberedAccounts[existingIndex].lastUsed = Date.now();
                const account = rememberedAccounts.splice(existingIndex, 1)[0];
                rememberedAccounts.unshift(account);
            } else {
                rememberedAccounts.unshift({
                    username: username,
                    lastUsed: Date.now(),
                    createdAt: Date.now()
                });
            }
            
            if (rememberedAccounts.length > STORAGE_CONFIG.MAX_ACCOUNTS) {
                rememberedAccounts = rememberedAccounts.slice(0, STORAGE_CONFIG.MAX_ACCOUNTS);
            }
            
            sessionStorage.setItem(STORAGE_CONFIG.ACCOUNT_MEMORY_KEY, JSON.stringify(rememberedAccounts));
        },
        
        getRememberedAccounts: function() {
            return [...rememberedAccounts];
        },
        
        removeAccount: function(username) {
            rememberedAccounts = rememberedAccounts.filter(acc => acc.username !== username);
            sessionStorage.setItem(STORAGE_CONFIG.ACCOUNT_MEMORY_KEY, JSON.stringify(rememberedAccounts));
        },
        
        clearAllAccounts: function() {
            rememberedAccounts = [];
            sessionStorage.removeItem(STORAGE_CONFIG.ACCOUNT_MEMORY_KEY);
        }
    };
})();

function generateSessionId() {
    const array = new Uint8Array(16);
    crypto.getRandomValues(array);
    return Array.from(array, byte => byte.toString(16).padStart(2, '0')).join('');
}

function hideLoginPanel() {
    var maincontents = document.getElementById('maincontents');
    var loginOverlay = document.getElementById('loginOverlay');

    document.body.removeEventListener('keypress', handleKeyPress);

    loginBlockUIforPage();

    if (loginOverlay) 
    {
        loginOverlay.remove();
    }
    
    LoginAttemptTracker.stopSync();

    setTimeout(function(){
        if(maincontents)
        {
            maincontents.style.display = "block";
        }
    },10); 
    setTimeout(function(){
        changeMainPage(document.getElementById("Div_LeftStreamMicrophone"));
        gotoMicrophone();
        setTimeout(function(){
            loginUnblockUIforPage();

            if(isViewerLogin)
            {
                hideViewerBlock(false); 
            }
            else
            {
                hideViewerBlock(true); 
            }
        },25);
        startGlobalCheck();
    },10); 
}

function hideViewerBlock(Action) 
{
    let mic_count_select_block = document.getElementById("mic_count_select_block");
    let mic_tabs_content_block = document.getElementById("mic_tabs_content_block");
    let cameralist_block = document.getElementById("cameralist_block");
    let network_block = document.getElementById("network_block");
    let profile_block = document.getElementById("profile_block");
    let setting_block = document.getElementById("setting_block");
    let Div_LeftAIDirector = document.getElementById("Div_LeftAIDirector");
    let Label_WebUser = document.getElementById("Label_WebUser");
    //console.log('isViewerLogin --->',isViewerLogin,'Action--->',Action);

    if(Action)
    {
        if(mic_count_select_block)
            mic_count_select_block.style.display = "none";
        if(mic_tabs_content_block)
            mic_tabs_content_block.style.display = "none";
        if(cameralist_block)
            cameralist_block.style.display = "none";
        if(network_block)
            network_block.style.display = "none";
        if(profile_block)
            profile_block.style.display = "none";
        if(setting_block)
            setting_block.style.display = "none";
        if(Div_LeftAIDirector)
        {
            if (!Div_LeftAIDirector.querySelector('.directorImg') && !Div_LeftAIDirector.querySelector('#Span_MenuStreamAIDirector')) {
                const directorContainer = document.createElement('div');
                directorContainer.className = 'directorContainer';

                const img = document.createElement('img');
                img.className = 'directorImg';

                const span = document.createElement('span');
                span.className = 'leftmenu_fontType listItemLink';
                span.id = 'Span_MenuStreamAIDirector';
                span.textContent = window.LanguageManager.getTranslatedText("Span_MenuStreamAIDirector");

                directorContainer.appendChild(img);
                directorContainer.appendChild(span);

                Div_LeftAIDirector.appendChild(directorContainer);

                Div_LeftAIDirector.style.display = 'block';
                Div_LeftAIDirector.classList.add('visible');

            } else {
                Div_LeftAIDirector.style.display = 'block';
                Div_LeftAIDirector.className = 'DirectorLeftMenuDiv menuL1 visible';
            }
        }

        if (window.LanguageManager && typeof window.LanguageManager.changeLanguage === "function") 
        {
            if(Label_WebUser)
                Label_WebUser.textContent = window.LanguageManager.getTranslatedText("Username_admin");
        }
    }
    else
    {
        if(mic_count_select_block)
            mic_count_select_block.style.display = "block";
        if(mic_tabs_content_block)
            mic_tabs_content_block.style.display = "block";
        if(cameralist_block)
            cameralist_block.style.display = "block";
        if(network_block)
            network_block.style.display = "block";
        if(profile_block)
            profile_block.style.display = "block";
        if(setting_block)
            setting_block.style.display = "block";
        if(Div_LeftAIDirector)
        {
            Div_LeftAIDirector.style.display = "none";
        }

        if (window.LanguageManager && typeof window.LanguageManager.changeLanguage === "function") 
        {
            if(Label_WebUser)
                Label_WebUser.textContent = window.LanguageManager.getTranslatedText("Username_viewer");
        }
            
    }
}

function changeLoginLang(e)
{
    document.getElementById("GobalSelectLanguage").value = e.target.value;
    if (window.LanguageManager && typeof window.LanguageManager.changeLanguage === "function") 
    {
      window.LanguageManager.changeLanguage(e.target.value);
      console.log('changeLoginLang --->',e.target.value);
    } 

    let rememberMe = document.getElementById("rememberLabelId");
    let userName = document.getElementById("inputUserName");
    let btnLogin = document.getElementById("btnLogin");
    let viewerLogin = document.getElementById("btnViewerLogin");
    
    rememberMe.textContent = window.LanguageManager.getTranslatedText("Remember_Me");
    userName.placeholder= window.LanguageManager.getTranslatedText("User_Name");
    btnLogin.textContent = window.LanguageManager.getTranslatedText("LogIn");
    viewerLogin.textContent = window.LanguageManager.getTranslatedText("Viewer_LogIn");

    let objSystem = {};
    var jsonmsg     = {};

    jsonmsg.Command = "SetSystemSetting";
    jsonmsg.System = {};
    objSystem.Language = parseInt(document.getElementById("GobalSelectLanguage").value,10);
    Object.assign(jsonmsg.System, objSystem);

    sendMessageIndex("SetSystemSetting",jsonmsg);

}

function updateLoginDisplay()
{
    if (window.LanguageManager && typeof window.LanguageManager.changeLanguage === "function") 
    {
        let rememberMe = document.getElementById("rememberLabelId");
        let userName = document.getElementById("inputUserName");
        let btnLogin = document.getElementById("btnLogin");
        let selectLang = document.getElementById("idWebLanguage");
        
        if(rememberMe)
            rememberMe.textContent = window.LanguageManager.getTranslatedText("Remember_Me");
        if(userName)
            userName.placeholder= window.LanguageManager.getTranslatedText("User_Name");
        if(btnLogin)
            btnLogin.textContent = window.LanguageManager.getTranslatedText("LogIn");
        if (selectLang) 
            selectLang.value = document.getElementById("GobalSelectLanguage").value ;
    } 
}

//----------------------------------------------other----------------------

function updatedGetCurrentVersionString(obj) {
    console.log('Version:', obj.Version);
    var page = sessionStorage.getItem("div_page");

   // if (obj.Version.includes("Beta") )
   { //Beta
        //console.log(page);
        //document.getElementById("modelNameLabel").removeClass = "modelName_label";
        //document.getElementById("modelNameLabel").className = "modelName_label";
        gVersion = obj.Version;
        var titleString = "AI-Box1"+" v"+obj.Version;
        var element = document.getElementById("modelNameLabel");
        element.innerHTML = titleString;

        if("UseNewRender" in obj )
            gUseNewRender = obj.UseNewRender;
        else
            gUseNewRender = false;
    }
}

function updatedGetStandByStatus(obj) {
    var page = sessionStorage.getItem("div_page");

    if (obj.Status == 0)
    { //0:UnStandBy
        isStandByStatus = false;
        //console.log(page);
        document.getElementById("powerBtn").removeClass = "PowerStandby_Btn";
        document.getElementById("powerBtn").className = "PowerOff_Btn";
        $('.LeftMenuDiv').removeClass("disabled").prop("disabled", false);
        $('.Btn_onoffvideo_style').removeClass("disabled").prop("disabled", false);
        $('#DivMainPage *').prop("disabled", false);
        lastPowerStatus = "on";
        gIsGetStandByStatus = true;
        if (page == null) {
            page = "Div_LeftStream";
        }
        $('#' + page).trigger('click');
    }
    else if (obj.Status == 1 || obj.Status == 2){
        isStandByStatus = true;
            if(!isProcessingMaxSoundQty)
            {
                document.getElementById("powerBtn").removeClass = "PowerOff_Btn";
                document.getElementById("powerBtn").className = "PowerStandby_Btn";
                $(".LeftMenuDiv").addClass("disabled").prop("disabled", true).off('click');
                $(".Btn_onoffvideo_style").addClass("disabled").prop("disabled", true).off('click');
                $("#DivMainPage *").prop("disabled", true);
                openPowerOff();
                lastPowerStatus = "off";
            }
    }
    else 
    {
        //if(obj.Status.includes("Processing Max Microphone Qty.") || obj.Status.includes("Processing"))
        {
            isStandByStatus = false;
            $(".LeftMenuDiv").addClass("disabled").prop("disabled", true).off('click');
            $(".Btn_onoffvideo_style").addClass("disabled").prop("disabled", true).off('click');
            $("#DivMainPage *").prop("disabled", true);
            processLastCommand();
        }
    }
}

function updatedGetSoundMaxQtyProcessStatus(obj) {
    //console.log('obj.Status:', obj.Status);
   
    if(obj.Status.includes("Processing Max Microphone Qty.") || obj.Status.includes("Processing"))
    {
        $(".LeftMenuDiv").addClass("disabled").prop("disabled", true).off('click');
        $(".Btn_onoffvideo_style").addClass("disabled").prop("disabled", true).off('click');
        $("#DivMainPage *").prop("disabled", true);
        processLastCommand();
        isProcessingMaxSoundQty = true;
    }
    else
    {
        isProcessingMaxSoundQty = false;
    }
}

function updatedProfileFilesList(obj){
    var ProfileFilsLength = 0;
    if (obj && obj.ProfileArray && Array.isArray(obj.ProfileArray) && obj.ProfileArray.length) {
        ProfileFilsLength = obj.ProfileArray.length;
    }
    var i = 0;

    $("#Select_Profile option").remove();

    for(i=0;i<ProfileFilsLength;i++)
    {
        $("#Select_Profile").append($("<option></option>").val(obj.ProfileArray[i].ID).text((i+1).toString()+": "+obj.ProfileArray[i].Profile));
    }
    
}

function updatedProfileIndex(obj) {
    //console.log('updatedProfileIndex', obj.CurrentProfileID);
    const $select = document.querySelector('#Select_Profile');
    var tempProfileId = parseInt(obj.CurrentProfileID, 10);
    if(tempProfileId>0 || tempProfileId <9)
        $select.value = tempProfileId;
}

function openLeftMenu() {

    //console.log("openLeftMenu");

    cameraSettings.ViewerMode = "3";
    showLeftMenu();
 
    var page = sessionStorage.getItem("div_page");
    //console.log(page);

    if (page == null) {

        page = "Div_LeftStream";
    }

    if(gIsGetStandByStatus){
        $('#' + page).trigger('click');
    }
}

function stopPreview() {
    if (document.getElementById("dmsloader")) {
        document.getElementById("dmsloader").onerror = function () {};
        document.getElementById("dmsloader").onload = function () {};
    }
    if (document.getElementById("dmsloaderFull")) {
        document.getElementById("dmsloaderFull").onerror = function () {};
        document.getElementById("dmsloaderFull").onload = function () {};
    }
}

function changeMainPage(obj) {
    var tabs_menu = document.getElementsByClassName("LeftMenuDiv");
    for (var x = 0; x < tabs_menu.length; x++) {
        tabs_menu[x].className = tabs_menu[x].className.replace(" LeftMenuActive", "");
    }
    if (obj == null) {
        //Div_LeftLiveView.className += " LeftMenuActive";
        Div_LeftStream.className += " LeftMenuActive";
        if (document.getElementById("ul_sysMenu").style.display != "none") {
            document.getElementById("ul_sysMenu").style.display = "none";
        }
        if (document.getElementById("ul_mainMenu").style.display != "none") {
            document.getElementById("ul_mainMenu").style.display = "none";
        }
    } else {
        sessionStorage.setItem("div_page", obj.id);
        if (obj.id != "Div_LeftLiveView") {
            stopPreview();
        }
        obj.className += " LeftMenuActive";    
        if (obj.id.indexOf("Div_LeftSystem") >= 0) {
            document.getElementById("Div_LeftSystem").className += " LeftMenuActive";
        }
        /*if (obj.id.indexOf("Div_LeftMaintenanceReboot") >= 0) {
            document.getElementById("Div_LeftMaintenance").className += " LeftMenuActive";
        }*/
        if (obj.id.indexOf("Div_LeftStream") >= 0) {
            document.getElementById("Div_LeftStream").className += " LeftMenuActive";
        }

        if (obj.id.indexOf("Div_LeftSystem") >= 0) {
            document.getElementById("ul_sysMenu").style.display = "block";
        } else {
            document.getElementById("ul_sysMenu").style.display = "none";
        }
        /*if (obj.id.indexOf("Div_LeftMaintenance") >= 0) {
            document.getElementById("ul_mainMenu").style.display = "block";
        } else {
            document.getElementById("ul_mainMenu").style.display = "none";
        }*/

        if (obj.id.indexOf("Div_LeftStream") >= 0) {
            document.getElementById("ul_streamMenu").style.display = "block";
        } else {
            document.getElementById("ul_streamMenu").style.display = "none";
        }
        currObjId = obj.id;

    }

    if(isViewerLogin)
    {
        hideViewerBlock(false); 
    }
    else
    {
        hideViewerBlock(true); 
    }

}

function showLeftMenu() {
    // blockUIforPage();
    /*$("#Div_LeftLiveView").on('click', function () {
        changeMainPage(this);
        openLiveview();
    });*/
    /*$("#Div_LeftAudio").on('click', function () {
        changeMainPage(this);
        openAudio();
    });*/
    $("#Div_LeftStream").on('click', function () {
        changeMainPage(document.getElementById("Div_LeftStreamMicrophone"));
        gotoMicrophone();
        UnblockUIforPage();
        if(isViewerLogin)
        {
            hideViewerBlock(false); 
        }
        else
        {
            hideViewerBlock(true); 
        }
    });

    $("#Div_LeftStreamMicrophone").on('click', function () {
        changeMainPage(this);
        openMicrophone();
        UnblockUIforPage();
        if(isViewerLogin)
        {
            hideViewerBlock(false); 
        }
        else
        {
            hideViewerBlock(true); 
        }
    });

    $("#Div_LeftStreamCameraList").on('click', function () {
        changeMainPage(this);
        openCameraList();
        UnblockUIforPage();
        if(isViewerLogin)
        {
            hideViewerBlock(false); 
        }
        else
        {
            hideViewerBlock(true); 
        }
    });

    $("#Div_LeftAIDirector").on('click', function () {
        changeMainPage(this);
        openAIDirector();
        UnblockUIforPage();
        if(isViewerLogin)
        {
            hideViewerBlock(false); 
        }
        else
        {
            hideViewerBlock(true); 
        }
    });

    $("#Div_LeftSystem").on('click', function () {
        /*if (cameraSettings.ViewerMode == 0) {
            changeMainPage(document.getElementById("Div_LeftSystemDevice"));
            openDevice();
        } else {
            changeMainPage(document.getElementById("Div_LeftSystemOutput"));
            openOutput();
        }*/
        changeMainPage(document.getElementById("Div_LeftSystemNetwork"));
        openNetwork();
        UnblockUIforPage();
        if(isViewerLogin)
        {
            hideViewerBlock(false); 
        }
        else
        {
            hideViewerBlock(true); 
        }
    });
    $("#Div_LeftSystemDevice").on('click', function () {
        changeMainPage(this);
        openDevice();
        UnblockUIforPage();
        if(isViewerLogin)
        {
            hideViewerBlock(false); 
        }
        else
        {
            hideViewerBlock(true); 
        }
    });
    $("#Div_LeftSystemOutput").on('click', function () {
        changeMainPage(this);
        openOutput();
        UnblockUIforPage();
        if(isViewerLogin)
        {
            hideViewerBlock(false); 
        }
        else
        {
            hideViewerBlock(true); 
        }
    });
    $("#Div_LeftSystemNetwork").on('click', function () {
        changeMainPage(this);
        openNetwork();
        UnblockUIforPage();
        if(isViewerLogin)
        {
            hideViewerBlock(false); 
        }
        else
        {
            hideViewerBlock(true); 
        }
    });
    $("#Div_LeftSystemProfiles").on('click', function () {
        changeMainPage(this);
        openMaintenance();
        UnblockUIforPage();
        if(isViewerLogin)
        {
            hideViewerBlock(false); 
        }
        else
        {
            hideViewerBlock(true); 
        }
    });
    $("#Div_LeftSystemSettings").on('click', function () {
        changeMainPage(this);
        openSettings();
        UnblockUIforPage();
        if(isViewerLogin)
        {
            hideViewerBlock(false); 
        }
        else
        {
            hideViewerBlock(true); 
        }
    });
    $("#Div_LeftSystemSecurity").on('click', function () {
        changeMainPage(this);
        openSecurity();
        UnblockUIforPage();
        if(isViewerLogin)
        {
            hideViewerBlock(false); 
        }
        else
        {
            hideViewerBlock(true); 
        }
    });
    $("#Div_LeftSystemDateTime").on('click', function () {
        changeMainPage(this);
        openDatetime();
        UnblockUIforPage();
        if(isViewerLogin)
        {
            hideViewerBlock(false); 
        }
        else
        {
            hideViewerBlock(true); 
        }
    });
    $("#Div_LeftSystemUser").on('click', function () {
        changeMainPage(this);
        openUser();
        UnblockUIforPage();
        if(isViewerLogin)
        {
            hideViewerBlock(false); 
        }
        else
        {
            hideViewerBlock(true); 
        }
    });
    $("#Div_LeftSystemControl").on('click', function () {
        changeMainPage(this);
        openControl();
        UnblockUIforPage();
        if(isViewerLogin)
        {
            hideViewerBlock(false); 
        }
        else
        {
            hideViewerBlock(true); 
        }
    });
    /*$("#Div_LeftMaintenance").on('click', function () {
        changeMainPage(this);
        openMaintenance();
    });*/
    /*$("#Div_LeftMaintenanceReboot").on('click', function () {
        changeMainPage(this);
        openReboot();
    });*/

    $("#Div_LeftVideoOutputSetting").on('click', function () {
        changeMainPage(this);
        openVideoOutputSetting();
        UnblockUIforPage();
        if(isViewerLogin)
        {
            hideViewerBlock(false); 
        }
        else
        {
            hideViewerBlock(true); 
        }
    });

    $("#Div_LeftAbout").on('click', function () {
        if(!isViewerLogin)
        {
            const now = Date.now();
            if (now - gLastClickTime > 500) {
                gCheckFiveTimeToDebugMode = 0;
            }
            gLastClickTime = now;
        
            gCheckFiveTimeToDebugMode++;
        }

        changeMainPage(this);
        openAbout();
        UnblockUIforPage();
        if(isViewerLogin)
        {
            hideViewerBlock(false); 
        }
        else
        {
            hideViewerBlock(true); 
        }
    });

    if (cameraSettings.ViewerMode == 0) { //admin 
        if (cameraSettings.ModelName == "VC-A71P-HN") {
            document.getElementById("Div_LeftSystemSecurity").style.display = "block";
        }
    } else if (cameraSettings.ViewerMode == 1) {
        //document.getElementById("Div_LeftLiveView").style.display="none";
        //document.getElementById("Div_LeftAudio").style.display = "none";
        document.getElementById("Div_LeftStream").style.display = "none";
        //document.getElementById("Div_LeftSystem").style.display = "none";
        document.getElementById("Div_LeftSystemDevice").style.display = "none";
        //document.getElementById("Div_LeftSystemOutput").style.display="none";
        document.getElementById("Div_LeftSystemNetwork").style.display = "none";
        document.getElementById("Div_LeftSystemSecurity").style.display = "none";
        document.getElementById("Div_LeftSystemDateTime").style.display = "none";
        document.getElementById("Div_LeftSystemUser").style.display = "none";
        //document.getElementById("Div_LeftSystemControl").style.display = "none";
        //document.getElementById("Div_LeftMaintenance").style.display = "none";
        //document.getElementById("Div_LeftMaintenanceReboot").style.display = "none";
        //document.getElementById("Div_LeftAbout").style.display="none";

    } else if (cameraSettings.ViewerMode == 3){//AI-BOX menu
         //document.getElementById("Div_LeftLiveView").style.display="none";
         //document.getElementById("Div_LeftAudio").style.display = "none";
         //document.getElementById("Div_LeftStream").style.display = "none";
         document.getElementById("Div_LeftSystemDevice").style.display = "none";
         document.getElementById("Div_LeftSystemOutput").style.display = "none";
         document.getElementById("Div_LeftSystemSecurity").style.display = "none";
         document.getElementById("Div_LeftSystemDateTime").style.display = "none";
         document.getElementById("Div_LeftSystemUser").style.display = "none";
         document.getElementById("Div_LeftSystemControl").style.display = "none";
         //document.getElementById("Div_LeftMaintenance").style.display = "none";
         //document.getElementById("Div_LeftMaintenanceReboot").style.display = "none";
         //document.getElementById("Div_LeftVideoOutputSetting").style.display = "none";
         //document.getElementById("Div_LeftAbout").style.display="none";   
    
    } else { //cameraSettings.ViewerMode == 2
        //document.getElementById("Div_LeftLiveView").style.display="none";
        //document.getElementById("Div_LeftAudio").style.display = "none";
        document.getElementById("Div_LeftStream").style.display = "none";
        document.getElementById("Div_LeftSystem").style.display = "none";
        document.getElementById("Div_LeftSystemDevice").style.display = "none";
        document.getElementById("Div_LeftSystemOutput").style.display = "none";
        document.getElementById("Div_LeftSystemNetwork").style.display = "none";
        document.getElementById("Div_LeftSystemSecurity").style.display = "none";
        document.getElementById("Div_LeftSystemDateTime").style.display = "none";
        document.getElementById("Div_LeftSystemUser").style.display = "none";
        document.getElementById("Div_LeftSystemControl").style.display = "none";
        //document.getElementById("Div_LeftMaintenance").style.display = "none";
        //document.getElementById("Div_LeftMaintenanceReboot").style.display = "none";
        //document.getElementById("Div_LeftAbout").style.display="none";
    }

}
//Submits an invalid authentication header, causing the user to be 'logged out'
function logout() {
    sessionStorage.removeItem("div_page");
    $.ajax({
            type: "GET",
            url: "PUT_YOUR_PROTECTED_URL_HERE",
            dataType: 'json',
            async: true,
            username: "some_username_that_doesn't_exist",
            password: "any_stupid_password",
            data: '{ "comment" }'
        })
        //In our case, we WANT to get access denied, so a success would be a failure.
        .done(function () {
            alert('Error!')
        })
        //Likewise, a failure *usually* means we succeeded.
        //set window.location to redirect the user to wherever you want them to go
        .fail(function () {
            window.location = "/";
        });
}

function getMessageNull(name) {
    return name + " Couldn't be null<br>";
}

function getMessageWrongLength(name, min, max) {
    return name + " should have minimum of " + min + " characters and maximum of " + max + " characters.<br>";
}

function getMessageInvalid(name, string) {
    return "Invalid " + name + ": " + string + "<br>";
}

function getMessageAddUser(name) {
    return "Added user " + name + " in the camera.";
}

function validate_IP(ip) {
    var x, x1, x2, x3, x4;
    x = ip.split(".");
    if (x.length == 4) {
        x1 = parseInt(x[0], 10);
        x2 = parseInt(x[1], 10);
        x3 = parseInt(x[2], 10);
        x4 = parseInt(x[3], 10);
        if (isNaN(x1) || isNaN(x2) || isNaN(x3) || isNaN(x4)) {
            warningMessage += getMessageInvalid("MPEGTS Link", cgiParam.MPEG2TSIP);
        }
        if ((x1 >= 0 && x1 <= 255) && (x2 >= 0 && x2 <= 255) && (x3 >= 0 && x3 <= 255) && (x4 >= 0 && x4 <= 255)) {
            return 0;
        } else {
            return -1;
        }
    } else {
        return -1;
    }
}

function validate_IsDifferentIp(ip1, ip2) {
    var x, y;
    x = ip1.split(".");
    y = ip2.split(".");
    if (x.length == 4 && y.length == 4) {
        if ((parseInt(x[0], 10) == parseInt(y[0], 10)) &&
            (parseInt(x[1], 10) == parseInt(y[1], 10)) &&
            (parseInt(x[2], 10) == parseInt(y[2], 10)) &&
            (parseInt(x[3], 10) == parseInt(y[3], 10))) {
            return -1;
        }
    }
    return 0;
}

function getMessageDuplicatePort() {
    return "Http's port number should not be same as Https's<br>";
}

function getMessageInvalidPort(name) {
    return name + " must be set greater than 1024 and can't use 1935, 3702, 5353, 8080, 8554, 8556, 8557, 52380, 52381<br>";
}

function getMessageInvalidPortHttp() {
    return "Http Port Must be Set 80 or greater than 1024 and can't use 1935, 3702, 5353, 8080, 8554, 8556, 8557, 52380, 52381<br>";
}

function getMessageInvalidPortHttps() {
    return "Https Port Must be Set 81 or greater than 1024 and can't use 1935, 3702, 5353, 8080, 8554, 8556, 8557, 52380, 52381<br>";
}

function getMessageDuplicateIp() {
    return "Another device on the network is using this ip address<br>";
}

function validate_Port(port) {
    var reservedPort = [1935, 3702, 5353, 8080, 8554, 8556, 8557, 52380, 52381];
    if (port <= 1024 || port >= 65535) {
        return -1;
    }
    for (var x = 0; x < reservedPort.length; x++) {
        if (port == reservedPort[x]) {
            return -1;
        }
    }
    return 0;
}

function filterNumberInRange(obj, min, max) {
    var num = obj.value;
    if (num < min)
        num = min;
    else if (num > max)
        num = max;
    obj.value = num;
}

function connectButtonToInput(btnMinusId, btnPlusId, textId, settings, para, minVal, maxVal, dimens, instant, refreshHndlr) {
    var strVal;
    var newVal;
    var timer1;
    var timer2;
    var regExp0 = /^-+$/g;
    var regExp = /^(-?[0-9]*|0)$/g;
    var txtId = textId.replace("#", "");
    if (maxVal < minVal) {
        //set err
        return;
    }
    if (para == "ExposureCompensation") {
        $(textId).val(settings[para] - 5);
    } else {
        $(textId).val(settings[para]);
    }
    $(btnMinusId).click(function () {
        if (document.getElementById(txtId).disabled == false) {
            if (timer1 != null) {
                clearInterval(timer1);
                timer1 = null;
            }
            strVal = $(textId).val();
            /* prevent users from sending redundant cmd */
            if (parseDecimal(strVal) != minVal) {
                newVal = strVal.length === 0 ? 0 : parseDecimal(strVal) - dimens;
                newVal = Math.min(maxVal, Math.max(newVal, minVal));
                if (instant == 1) {
                    /* change Image immediately */
                    ;
                    setCmdAction(textId, para, newVal, refreshHndlr);
                } else {
                    /* don't change Image immediately */
                    $(textId).val(newVal);
                    settings[para] = newVal;
                    if (refreshHndlr != null) restartTimerManager(refreshHndlr);
                }
            }
        }
    });
    $(btnMinusId).mousedown(function () {
        var i = 0;
        if (timer1 != null) {
            clearInterval(timer1);
            timer1 = null;
        }
        timer1 = setInterval(function () {
            i += 80;
            if (i >= 1500) {
                i = 0;
                if (document.getElementById(txtId).disabled == false) {
                    strVal = $(textId).val();
                    /* prevent users from sending redundant cmd */
                    if (parseDecimal(strVal) != minVal) {
                        newVal = strVal.length === 0 ? 0 : parseDecimal(strVal) - dimens;
                        newVal = Math.min(maxVal, Math.max(newVal, minVal));
                        if (instant == 1) {
                            /* change Image immediately */
                            ;
                            setCmdAction(textId, para, newVal, refreshHndlr);
                        } else {
                            /* don't change Image immediately */
                            $(textId).val(newVal);
                            settings[para] = newVal;
                            if (refreshHndlr != null) restartTimerManager(refreshHndlr);
                        }
                    }
                }
            }
        }, 10)
    });
    $(btnMinusId).mouseup(function () {
        if (timer1 != null) {
            clearInterval(timer1);
            timer1 = null;
        }
        if (refreshHndlr != null) restartTimerManager(refreshHndlr);
    });
    $(btnMinusId).mouseleave(function () {
        if (timer1 != null) {
            clearInterval(timer1);
            timer1 = null;
        }
        if (refreshHndlr != null) restartTimerManager(refreshHndlr);
    });
    //------------------------------------------------------------------------------------------------------------
    $(btnPlusId).click(function () {
        if (document.getElementById(txtId).disabled == false) {
            if (timer2 != null) {
                clearInterval(timer2);
                timer2 = null;
            }
            strVal = $(textId).val();
            /* prevent users from sending redundant cmd */
            if (parseDecimal(strVal) != maxVal) {
                newVal = strVal.length === 0 ? 0 : parseDecimal(strVal) + dimens;
                newVal = Math.min(maxVal, Math.max(newVal, minVal));
                if (instant == 1) {
                    /* change Image immediately */
                    ;
                    setCmdAction(textId, para, newVal, refreshHndlr);
                } else {
                    /* don't change Image immediately */
                    $(textId).val(newVal);
                    settings[para] = newVal;
                    if (refreshHndlr != null) restartTimerManager(refreshHndlr);
                }
            }
        }
    });
    $(btnPlusId).mousedown(function () {
        var i = 0;
        if (timer2 != null) {
            clearInterval(timer2);
            timer2 = null;
        }
        timer2 = setInterval(function () {
            i += 80;
            if (i >= 1500) {
                i = 0;
                if (document.getElementById(txtId).disabled == false) {
                    strVal = $(textId).val();
                    /* prevent users from sending redundant cmd */
                    if (parseDecimal(strVal) != maxVal) {
                        newVal = strVal.length === 0 ? 0 : parseDecimal(strVal) + dimens;
                        newVal = Math.min(maxVal, Math.max(newVal, minVal));
                        if (instant == 1) {
                            /* change Image immediately */
                            ;
                            setCmdAction(textId, para, newVal, refreshHndlr);
                        } else {
                            /* don't change Image immediately */
                            $(textId).val(newVal);
                            settings[para] = newVal;
                            if (refreshHndlr != null) restartTimerManager(refreshHndlr);
                        }
                    }
                }
            }
        }, 10)
    });
    $(btnPlusId).mouseup(function () {
        if (timer2 != null) {
            clearInterval(timer2);
            timer2 = null;
        }
        if (refreshHndlr != null) restartTimerManager(refreshHndlr);
    });
    $(btnPlusId).mouseleave(function () {
        if (timer2 != null) {
            clearInterval(timer2);
            timer2 = null;
        }
        if (refreshHndlr != null) restartTimerManager(refreshHndlr);
    });
    if ((textId == "#exposureCompLevelTextInput") || (textId == "#panLeftLimitTextInput") || (textId == "#tiltDownLimitTextInput")) {
        /* range : -6 <-> 5 @Lawliet */
        function inputChange() {
            strVal = $(textId).val();
            if (strVal.match(regExp0)) {
                /* case : - , -- , --- , ... */
                newVal = "-";
                $(textId).val(newVal);
            } else {
                //filter : positive integer & negative integer & 0 : /^(-?[1-9][0-9]*|0)$/g
                if (newVal = strVal.match(regExp)) {
                    //match , special case : -0
                    newVal = strVal.length === 0 ? 0 : parseDecimal(strVal);
                    newVal = Math.min(maxVal, Math.max(newVal, minVal));
                } else {
                    //not match : null
                    /* case : xx- , ex. -6- => -6 */
                    if (("-" == strVal.charAt(strVal.length - 1))) {
                        newVal = strVal.substring(0, (strVal.length - 1)); //notice index of stop : stringObject.substring(start,stop)
                    } else {
                        newVal = 0;
                    }
                }
                if (instant == 1) {
                    /* change Image immediately */
                    ;
                    setCmdAction(textId, para, newVal, refreshHndlr);
                } else {
                    /* don't change Image immediately */
                    $(textId).val(newVal);
                    settings[para] = newVal;
                    if (refreshHndlr != null) restartTimerManager(refreshHndlr);
                }
            }
        }
        registerChangeHandlers($(textId), inputChange).keypress(filterNegNumKey);
    } else {
        /* range : 0 <-> value @Lawliet */
        function inputChange() {
            strVal = $(textId).val();
            //filter : positive integer & negative integer & 0 : /^(-?[1-9][0-9]*|0)$/g
            if (newVal = strVal.match(regExp)) {
                //match
                newVal = strVal.length === 0 ? 0 : parseDecimal(strVal);
                newVal = Math.min(maxVal, Math.max(newVal, minVal));
            } else {
                //not match : null
                newVal = 0;
            }
            if (instant == 1) {
                ;
                setCmdAction(textId, para, newVal, refreshHndlr);
            } else {
                $(textId).val(newVal);
                settings[para] = newVal;
                if (refreshHndlr != null) restartTimerManager(refreshHndlr);
            }
        }
        registerChangeHandlers($(textId), inputChange).keypress(filterNumKey);
    }
}

function sysMenuChange() {
    /*if (document.getElementById("ul_sysMenu").style.display != "none") {
        document.getElementById("ul_sysMenu").style.display = "none";
    } else {
        document.getElementById("ul_sysMenu").style.display = "block";
    }*/
}

function mainMenuChange() {
    /*if (document.getElementById("ul_mainMenu").style.display != "none")
        document.getElementById("ul_mainMenu").style.display = "none";
    else
        document.getElementById("ul_mainMenu").style.display = "block";*/
}

function openPowerOff() {
    $("#DivMainPage").load("./page/poweroff.html", function () {
        if(!isAuthenticated && !isViewerLogin)
            return;
/*
        $.ajax({
            url: "/cgi/inquiry.cgi?inqjs=network",
            type: "GET",
            error: function (xhr) {
                console.log("Get system info fail");
            },
            success: function (response) {
                var pcDateNow = {};
                const regEx = /var\s(.*?)\=\"(.*?)\"/gm;
                var result = [];
                while (result = regEx.exec(response)) {
                    cameraSettings[result[1]] = result[2];
                }

                $("#cameraIDLabel").text(cameraSettings.CameraName);
                $("#locationLabel").text(cameraSettings.Location);
            }
        });
*/
    });
}

function processLastCommand()
{
    $("#DivMainPage").load("./page/processCommand.html", function () {
        
            });
}

function getBlockUIMessage() {



    let message = "";

    if (fwUpdateRunning) 
    {
        return message = `<h3>${window.LanguageManager.getTranslatedText("The_power_during_the_firmware_update")}</h3>`;
    } 
    else 
    {
        if(gWebSocketErrorBlockUIPage)
        {
            setLoginStatus(false);
            gHadLogin = false;
            clearLoginStatus();
            return message = `<h3 style ='width:800px;'>${window.LanguageManager.getTranslatedText("web_page_connection_has_failed")}</h3>`;
        }
        else if(gIsControlByGui)
        {
            return message = `<h3 style ='width:800px;'>${window.LanguageManager.getTranslatedText("web_page_controlByGUI")}</h3>`;
        }
        else if(getAIDirectorBlockUIPage)
        {    
            return message = `
            <h3 id='dynamicMessage' style ='width:800px;text-align:left;'>
                ${window.LanguageManager.getTranslatedText("Director_Mode_Profile_is_loading")} 
                <span>…</span>
                <span id='IndexSchedule'>0</span>
                <span>%</span>
                <img src="../images/downloading-unscreen.gif" style="width:50px;height:50px;vertical-align:middle;">
            </h3>
            `;
        }
        else if(getSoundAllSetForAIDirector)
        {
            return message = `
            <h3 id='dynamicMessage' style ='width:1000px;text-align:left;'>
                ${window.LanguageManager.getTranslatedText("Director_Mode_Microphone_Setting_is_loading")}
                <span>…</span>
                <span id='IndexMicSchedule'>0</span>
                <span>%</span>
                <img src="../images/downloading-unscreen.gif" style="width:50px;height:50px;vertical-align:middle;">
            </h3>
            `;
        }
        else if(getAIDirectorConfigDataInit)
        {
            return message = `
            <h3 id='dynamicMessage' style ='width:580px;text-align:left;'>
                ${window.LanguageManager.getTranslatedText("Configuration_initialization_in_progress")}
                <img src="../images/downloading-unscreen.gif" style="width:50px;height:50px;vertical-align:middle;">
            </h3>
            `;
        }
        else if(gGetBC200ConnectErrorBlockUIPage)
        {
            
            return message = `<h3 style ='width:800px;'>${window.LanguageManager.getTranslatedText("BC200ConnectError")}</h3>`;
        }
        else if(gCameraDeleteBlockFlag || gCameraDisconnectBlockFlag || gCameraSearchBlockFlag)
        {
            if(document.getElementById("GobalSelectLanguage").value == 0)
            {
                return message = `
                <h3 id='dynamicMessage' style ='width:240px;text-align:left;'>
                    ${window.LanguageManager.getTranslatedText("Please_wait")}
                    <img src="../images/downloading-unscreen.gif" style="width:50px;height:50px;vertical-align:middle;">
                </h3>
                `;
            }
            else
            {
                return message = `
                <h3 id='dynamicMessage' style ='width:200px;text-align:left;'>
                    ${window.LanguageManager.getTranslatedText("Please_wait")}
                    <img src="../images/downloading-unscreen.gif" style="width:50px;height:50px;vertical-align:middle;">
                </h3>
                `;
            }



        }
        else
        {
            return message = `<h3 style ='width:350px;'>
                ${window.LanguageManager.getTranslatedText("Please_wait")}
                <img src="../images/downloading-unscreen.gif" style="width:50px;height:50px;vertical-align:middle;">
            </h3>`;
        }
    }
}

function updateVideoOnOffButton(state) {
    var selectLang = document.getElementById("GobalSelectLanguage");
    var langIndex = parseInt(selectLang.value, 10);
    var langCode = langIndex === 1 ? "tw" : (langIndex === 2 ? "zh" : "en");
    var translations = window.languages[langCode];
  
    if (!translations) {
      return;
    }
  
    var button = document.getElementById("videoOnOffButton");
    if (!button) {
      return;
    }
  
    if (state == 1) 
    {
      gIsVideoStart = 1;
      button.innerHTML = translations["Stop_Video_Output"] || "Stop Video Output";
    } 
    else 
    {
      gIsVideoStart = 0;
      button.innerHTML = translations["Start_Video_Output"] || "Start Video Output";
    }
}

function gotoMicrophone() {
    $('#Div_LeftStreamMicrophone').trigger('click');
}

function GotoVideoOutputSetting() {

    $('#Div_LeftVideoOutputSetting').trigger('click');

}

function getCurrObjID() {
    return currObjId;
}

function disabledLeftMenu() {
 
/*
    $("#Div_LeftStream").addClass("disabled").prop("disabled", true).off('click');
    $("#Div_LeftNetwork").addClass("disabled").prop("disabled", true).off('click');
    $("#Div_LeftVideoOutputSetting").off('click');
    $("#Div_LeftMaintenance").addClass("disabled").prop("disabled", true).off('click');
    $("#Div_LeftAbout").addClass("disabled").prop("disabled", true).off('click');
*/
    console.log('currObjId :', currObjId);
/*    if ($("#Div_LeftStream").attr('id') == currObjId)
        $("#Div_LeftStream").off('click');
    else
        $("#Div_LeftStream").addClass("disabled").prop("disabled", true).off('click');

    if ($("#Div_LeftStreamMicrophone").attr('id') == currObjId)
        $("#Div_LeftStreamMicrophone").off('click');
    else
        $("#Div_LeftStreamMicrophone").addClass("disabled").prop("disabled", true).off('click');

    if ($("#Div_LeftStreamCameraList").attr('id') == currObjId)
        $("#Div_LeftStreamCameraList").off('click');
    else
        $("#Div_LeftStreamCameraList").addClass("disabled").prop("disabled", true).off('click');

    if ($("#Div_LeftVideoOutputSetting").attr('id') == currObjId)
        $("#Div_LeftVideoOutputSetting").off('click');
    else
        $("#Div_LeftVideoOutputSetting").addClass("disabled").prop("disabled", true).off('click');

    if ($("#Div_LeftSystem").attr('id') == currObjId)
        $("#Div_LeftSystem").off('click');
    else
        $("#Div_LeftSystem").addClass("disabled").prop("disabled", true).off('click');

    if ($("#Div_LeftSystemNetwork").attr('id') == currObjId)
        $("#Div_LeftSystemNetwork").off('click');
    else
        $("#Div_LeftSystemNetwork").addClass("disabled").prop("disabled", true).off('click');

    if ($("#Div_LeftSystemProfiles").attr('id') == currObjId)
        $("#Div_LeftSystemProfiles").off('click');
    else
        $("#Div_LeftSystemProfiles").addClass("disabled").prop("disabled", true).off('click');

    if ($("#Div_LeftSystemSettings").attr('id') == currObjId)
        $("#Div_LeftSystemSettings").off('click');
    else
        $("#Div_LeftSystemSettings").addClass("disabled").prop("disabled", true).off('click');

    if ($("#Div_LeftAbout").attr('id') == currObjId)
        $("#Div_LeftAbout").off('click');
    else
        $("#Div_LeftAbout").addClass("disabled").prop("disabled", true).off('click');*/
}

function enabledLeftMenu() {

/*    $("#Div_LeftStream").removeClass("disabled").prop("disabled", false);
    $("#Div_LeftStreamMicrophone").removeClass("disabled").prop("disabled", false);
    $("#Div_LeftStreamCameraList").removeClass("disabled").prop("disabled", false);
    $("#Div_LeftVideoOutputSetting").removeClass("disabled").prop("disabled", false);
    $("#Div_LeftSystem").removeClass("disabled").prop("disabled", false);
    $("#Div_LeftSystemNetwork").removeClass("disabled").prop("disabled", false);
    $("#Div_LeftSystemProfiles").removeClass("disabled").prop("disabled", false);
    $("#Div_LeftSystemSettings").removeClass("disabled").prop("disabled", false);
    $("#Div_LeftAbout").removeClass("disabled").prop("disabled", false);

    $("#Div_LeftStream").on('click', function () {
        changeMainPage(document.getElementById("Div_LeftStreamMicrophone"));
        gotoMicrophone();
        openMicrophone();
    });

    $("#Div_LeftStreamMicrophone").on('click', function () {
        changeMainPage(this);
        openMicrophone();
    });

    $("#Div_LeftStreamCameraList").on('click', function () {
        changeMainPage(this);
        openCameraList();
    });

    $("#Div_LeftVideoOutputSetting").on('click', function () {
        changeMainPage(this);
        openVideoOutputSetting();
    });

    $("#Div_LeftSystem").on('click', function () {
        changeMainPage(document.getElementById("Div_LeftSystemNetwork"));
        openNetwork();
    });

    $("#Div_LeftSystemNetwork").on('click', function () {
        changeMainPage(this);
        openNetwork();
    });

    $("#Div_LeftSystemProfiles").on('click', function () {
        changeMainPage(this);
        openMaintenance();
    });

    $("#Div_LeftSystemSettings").on('click', function () {
        changeMainPage(this);
        openSettings();
    });

    $("#Div_LeftAbout").on('click', function () {
        changeMainPage(this);
        openAbout();
    });*/

}

function disabledLeftMenuOnPopWindowOpen()
 {
 
    
        $("#Div_LeftStream").addClass("disabled").prop("disabled", true).off('click');
        $("#Div_LeftNetwork").addClass("disabled").prop("disabled", true).off('click');
        $("#Div_LeftVideoOutputSetting").off('click');
        $("#Div_LeftMaintenance").addClass("disabled").prop("disabled", true).off('click');
        $("#Div_LeftAbout").addClass("disabled").prop("disabled", true).off('click');

    
           console.log('currObjId :', currObjId);
        if ($("#Div_LeftStream").attr('id') == currObjId)
            $("#Div_LeftStream").off('click');
        else
            $("#Div_LeftStream").addClass("disabled").prop("disabled", true).off('click');
    
        if ($("#Div_LeftStreamMicrophone").attr('id') == currObjId)
            $("#Div_LeftStreamMicrophone").off('click');
        else
            $("#Div_LeftStreamMicrophone").addClass("disabled").prop("disabled", true).off('click');
    
        if ($("#Div_LeftStreamCameraList").attr('id') == currObjId)
            $("#Div_LeftStreamCameraList").off('click');
        else
            $("#Div_LeftStreamCameraList").addClass("disabled").prop("disabled", true).off('click');
    
        if ($("#Div_LeftVideoOutputSetting").attr('id') == currObjId)
            $("#Div_LeftVideoOutputSetting").off('click');
        else
            $("#Div_LeftVideoOutputSetting").addClass("disabled").prop("disabled", true).off('click');
    
        if ($("#Div_LeftSystem").attr('id') == currObjId)
            $("#Div_LeftSystem").off('click');
        else
            $("#Div_LeftSystem").addClass("disabled").prop("disabled", true).off('click');
    
        if ($("#Div_LeftSystemNetwork").attr('id') == currObjId)
            $("#Div_LeftSystemNetwork").off('click');
        else
            $("#Div_LeftSystemNetwork").addClass("disabled").prop("disabled", true).off('click');
    
        if ($("#Div_LeftSystemProfiles").attr('id') == currObjId)
            $("#Div_LeftSystemProfiles").off('click');
        else
            $("#Div_LeftSystemProfiles").addClass("disabled").prop("disabled", true).off('click');
    
        if ($("#Div_LeftSystemSettings").attr('id') == currObjId)
            $("#Div_LeftSystemSettings").off('click');
        else
            $("#Div_LeftSystemSettings").addClass("disabled").prop("disabled", true).off('click');
    
        if ($("#Div_LeftAbout").attr('id') == currObjId)
            $("#Div_LeftAbout").off('click');
        else
            $("#Div_LeftAbout").addClass("disabled").prop("disabled", true).off('click');

        document.getElementById("videoOnOffButton").disabled = true;
        document.getElementById("Select_Profile").disabled = true;
        if(document.getElementById("deviceCntSel"))
            document.getElementById("deviceCntSel").disabled = true;
        document.getElementById("powerBtn").disabled = true;
        document.getElementById("logoutBtn").disabled = true;
    }
    
    function enabledLeftMenuOnPopWindowClose()
     {
        $("#Div_LeftStream").removeClass("disabled").prop("disabled", false);
        $("#Div_LeftStreamMicrophone").removeClass("disabled").prop("disabled", false);
        $("#Div_LeftStreamCameraList").removeClass("disabled").prop("disabled", false);
        $("#Div_LeftVideoOutputSetting").removeClass("disabled").prop("disabled", false);
        $("#Div_LeftSystem").removeClass("disabled").prop("disabled", false);
        $("#Div_LeftSystemNetwork").removeClass("disabled").prop("disabled", false);
        $("#Div_LeftSystemProfiles").removeClass("disabled").prop("disabled", false);
        $("#Div_LeftSystemSettings").removeClass("disabled").prop("disabled", false);
        $("#Div_LeftAbout").removeClass("disabled").prop("disabled", false);
    
        $("#Div_LeftStream").on('click', function () {
            changeMainPage(document.getElementById("Div_LeftStreamMicrophone"));
            gotoMicrophone();
            if(isViewerLogin)
            {
                hideViewerBlock(false); 
            }
            else
            {
                hideViewerBlock(true); 
            }
        });
    
        $("#Div_LeftStreamMicrophone").on('click', function () {
            changeMainPage(this);
            openMicrophone();
            if(isViewerLogin)
            {
                hideViewerBlock(false); 
            }
            else
            {
                hideViewerBlock(true); 
            }
        });
    
        $("#Div_LeftStreamCameraList").on('click', function () {
            changeMainPage(this);
            openCameraList();
            if(isViewerLogin)
            {
                hideViewerBlock(false); 
            }
            else
            {
                hideViewerBlock(true); 
            }
        });
    
        $("#Div_LeftVideoOutputSetting").on('click', function () {
            changeMainPage(this);
            openVideoOutputSetting();
            if(isViewerLogin)
            {
                hideViewerBlock(false); 
            }
            else
            {
                hideViewerBlock(true); 
            }
        });
    
        $("#Div_LeftSystem").on('click', function () {
            changeMainPage(document.getElementById("Div_LeftSystemNetwork"));
            openNetwork();
            if(isViewerLogin)
            {
                hideViewerBlock(false); 
            }
            else
            {
                hideViewerBlock(true); 
            }
        });
    
        $("#Div_LeftSystemNetwork").on('click', function () {
            changeMainPage(this);
            openNetwork();
            if(isViewerLogin)
            {
                hideViewerBlock(false); 
            }
            else
            {
                hideViewerBlock(true); 
            }
        });
    
        $("#Div_LeftSystemProfiles").on('click', function () {
            changeMainPage(this);
            openMaintenance();
            if(isViewerLogin)
            {
                hideViewerBlock(false); 
            }
            else
            {
                hideViewerBlock(true); 
            }
        });
    
        $("#Div_LeftSystemSettings").on('click', function () {
            changeMainPage(this);
            openSettings();
            if(isViewerLogin)
            {
                hideViewerBlock(false); 
            }
            else
            {
                hideViewerBlock(true); 
            }
        });
    
        $("#Div_LeftAbout").on('click', function () {
            changeMainPage(this);
            openAbout();
            if(isViewerLogin)
            {
                hideViewerBlock(false); 
            }
            else
            {
                hideViewerBlock(true); 
            }
        });
        
        document.getElementById("videoOnOffButton").disabled = false;
        document.getElementById("Select_Profile").disabled = false;
        if(document.getElementById("deviceCntSel"))
            document.getElementById("deviceCntSel").disabled = false;
        document.getElementById("powerBtn").disabled = false;
        document.getElementById("logoutBtn").disabled = false;
    }
    
    function updatedCheckDanteActiveDataIsExport(obj) 
    {        
        if(gIsCheckDanteActiveIsExport) return;
        
        if('IsDanteEnable' in obj)
        {
            var isDanteEnable = obj.IsDanteEnable;
            if(isDanteEnable)
            {
                gIsCheckDanteActiveIsExport = true;
                
                var isNeedHint = true;
                if( 'NeedHint' in obj)
                    isNeedHint = obj.NeedHint;

                if(isNeedHint)
                {
                    // var hintString = "The process of saving and exporting Dante activation data is crucial to ensure seamless device operation. "+
                    //                  "Regular backups help prevent authentication failures in case of device replacements or unforeseen issues. "+
                    //                  "Manual backups are recommended for enhanced reliability and data security.\n";
                    var hintString = window.LanguageManager.getTranslatedText("Dante_Activation_Message");
                    var hintString2 = window.LanguageManager.getTranslatedText("Dante_Activation_Instructions");
                    //var hintString2 = "(Go to the System Tab > Settings > Dante , and click \“Export\” under ActivationData. )";
                    
                    const popupWindow = document.getElementById("danteHint_popup_Window");
                    if (popupWindow) 
                    {
                        popupWindow.style.display = "block";                
                
                        popupWindow.innerHTML = ""; 
                                     
                        
                        let label_DanteHintTitle = document.createElement("label");
                        label_DanteHintTitle.id = "gDanteHintTitle";
                        label_DanteHintTitle.className = "White_Font_Arial_16_bold label_tr";
                        label_DanteHintTitle.style.cssText = "width : 300px; margin-left : 20px; margin-top : 25px;  margin-bottom : 10px;";
                        label_DanteHintTitle.innerText = window.LanguageManager.getTranslatedText("Dante_Activation_Data_Backup");                
                
                        let label_DanteHintContext = document.createElement("label");
                        label_DanteHintContext.id = "gDanteHintContext";
                        label_DanteHintContext.className = "White_Font_Arial_14 label_tr";
                        label_DanteHintContext.style.cssText = "width : 490px; margin-left : 30px;";
                        label_DanteHintContext.innerHTML = hintString;

                        let label_DanteOperation= document.createElement("label");
                        label_DanteOperation.id = "glabel_DanteOperation";
                        label_DanteOperation.className = "White_Font_Arial_12_bold label_tr";
                        label_DanteOperation.style.cssText = "width : 490px; margin-left : 30px;";
                        label_DanteOperation.innerText = hintString2;
                
                        const table_DanteHint = document.createElement("table");
                        table_DanteHint.id = "table_DanteHint";
                        table_DanteHint.className = "advanced-table";

                        let tr_DanteButton = document.createElement("tr");
                        tr_DanteButton.className = "stream_tr2 Font_Arial_14";

                        var td_NoHintCheckBox = document.createElement("td");
                        var changeNoHintStatus = document.createElement("input");
                        changeNoHintStatus.type = "checkbox";
                        changeNoHintStatus.id = "changeDanteNoHintStatus";
                        changeNoHintStatus.className = "mic-xy-checkbox"; // Apply the custom class for styling
                        changeNoHintStatus.style.cssText = "margin-top : 30px;margin-left : 30px;";
                        changeNoHintStatus.checked = false;
                        changeNoHintStatus.addEventListener("change", changeNoHintClick);
                        td_NoHintCheckBox.appendChild(changeNoHintStatus);
                       
                        let td_DanteNoHintString = document.createElement("td");
                        let label_DanteNoHint= document.createElement("label");
                        label_DanteNoHint.id = "glabel_DanteOperation";
                        label_DanteNoHint.className = "White_Font_Arial_14 label_tr";
                        label_DanteNoHint.style.cssText = "width : 300px; margin-top : 30px; margin-left : 10px;";
                        label_DanteNoHint.innerText = window.LanguageManager.getTranslatedText("Do_Not_Notify_Next_Time");
                        td_DanteNoHintString.appendChild(label_DanteNoHint);
                
                        let td_DanteOKButton = document.createElement("td");
                        var OkButton = document.createElement("button");
                        OkButton.id = "gBtnDanteHintOK";
                        OkButton.type = "button";
                        OkButton.className = "Btn_style applyButton";
                        OkButton.style.cssText = "margin-left : 60px; margin-top : 30px;";
                        OkButton.disabled = false;
                        OkButton.innerText = window.LanguageManager.getTranslatedText("OK");
                        OkButton.setAttribute("onclick", "onDanteHintOkClick()");
                        td_DanteOKButton.appendChild(OkButton);

                        tr_DanteButton.appendChild(td_NoHintCheckBox);
                        tr_DanteButton.appendChild(td_DanteNoHintString); 
                        tr_DanteButton.appendChild(td_DanteOKButton);                               
                        table_DanteHint.appendChild(tr_DanteButton);
                
                        popupWindow.appendChild(label_DanteHintTitle);
                        popupWindow.appendChild(label_DanteHintContext);
                        popupWindow.appendChild(label_DanteOperation);
                        popupWindow.appendChild(table_DanteHint);
                        //popupWindow.appendChild(OkButton);
                
                    }
                }
            }
        }
        
    }

    function onDanteHintOkClick()
    {
        const popupWindow = document.getElementById("danteHint_popup_Window");
        if (popupWindow) 
        {
            popupWindow.style.display = 'none';
        }
    }

    function changeNoHintClick(e)
    {
        console.log("changeNoHintClick");
        var hintCheckbox=document.getElementById("changeDanteNoHintStatus");
        if(hintCheckbox)
        {
            console.log("changeNoHintClick",hintCheckbox.checked);
            var obj = {
                Command: "SetDanteActiveDataHint",
                HintStatus: !hintCheckbox.checked
            };
            sendMessageIndex("SetDanteActiveDataHint",obj);
        }
    }

    function showWebSocketLost()
    {        
        if(gWebSocketErrorBlockUIPage) 
        {
            blockUIforPage();
            setLoginStatus(false);
            gHadLogin = false;
            clearLoginStatus();
        }
    }

    function showControlByGUI()
    {        
       if (gIsControlByGui) 
        {
            waitDanteApplyUnBlockUIforPage() 
            getMicTabIsGettingUnblockUIforPage();     
            waitDanteApplyUnBlockUIforPage();  
            blockUIforPage();
        }
    }

function makePasswordFieldReadonly(inputId) 
{
    const input = document.getElementById(inputId);
    if (!input) return;
    
    input.setAttribute('readonly', true);
    
    input.onfocus = function() { this.blur(); };
    input.onmousedown = function(e) { e.preventDefault(); return false; };
    input.onselectstart = function(e) { e.preventDefault(); return false; };
    input.oncontextmenu = function(e) { e.preventDefault(); return false; };
    input.oncopy = function(e) { e.preventDefault(); return false; };
    input.oncut = function(e) { e.preventDefault(); return false; };
    input.onpaste = function(e) { e.preventDefault(); return false; };
    input.ondrag = function(e) { e.preventDefault(); return false; };
    input.ondragstart = function(e) { e.preventDefault(); return false; };
    
    input.onkeydown = function(e) { e.preventDefault(); return false; };
    input.onkeyup = function(e) { e.preventDefault(); return false; };
    
    input.addEventListener('touchstart', function(e) {
        e.preventDefault();
    }, { passive: false });
}

function gotoDirectorPage()
{
    if(!isViewerLogin)
    {
        $("#Div_LeftAIDirector").trigger('click');
    }
}

